/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template;

import com.bokesoft.yes.excel.template.ColumnExpandItem;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelSheet;
import com.bokesoft.yes.excel.template.IExcelCellProcess;
import com.bokesoft.yes.excel.template.IExcelColumnCellObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ExcelColumnExpandCellList
implements IExcelColumnCellObject {
    private ExcelCell cell = null;
    private ArrayList<ExcelCell> excelCellArray = new ArrayList();
    private HashMap<Integer, ExcelCell> excelCellMap = new HashMap();

    @Override
    public void setCell(ExcelCell excelCell) {
        this.cell = excelCell;
    }

    public ExcelCell getCell() {
        return this.cell;
    }

    public void add(ExcelCell excelCell) {
        this.excelCellArray.add(excelCell);
        if (excelCell != null) {
            this.excelCellMap.put(excelCell.getRowIndex(), excelCell);
        }
    }

    public void addAll(List<ExcelCell> list) {
        for (int i = 0; i < list.size(); ++i) {
            ExcelCell excelCell = list.get(i);
            this.excelCellArray.add(excelCell);
            this.excelCellMap.put(excelCell.getRowIndex(), excelCell);
        }
    }

    @Override
    public int getObjectType() {
        return 0;
    }

    @Override
    public IExcelColumnCellObject clone() {
        ExcelColumnExpandCellList excelColumnExpandCellList = new ExcelColumnExpandCellList();
        excelColumnExpandCellList.setCell(this.cell);
        for (ExcelCell excelCell : this.excelCellArray) {
            if (excelCell == null) {
                excelColumnExpandCellList.add(null);
                continue;
            }
            excelColumnExpandCellList.add(excelCell.clone());
        }
        return excelColumnExpandCellList;
    }

    @Override
    public void traversalCell(ColumnExpandItem columnExpandItem, IExcelCellProcess iExcelCellProcess) {
        Iterator<ExcelCell> iterator = this.excelCellArray.iterator();
        while (iterator.hasNext()) {
            iExcelCellProcess.process(columnExpandItem, iterator.next());
        }
    }

    @Override
    public void getLeafCells(LinkedList<ExcelCell> linkedList, int n) {
        linkedList.add(this.excelCellMap.get(n));
    }

    @Override
    public void processMerge(ExcelSheet excelSheet) {
    }
}

