/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.input.reader;

import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReader;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.SheetReader;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import java.util.LinkedHashMap;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class WorkbookReader
implements IInputReaderBag {
    private Workbook workbook = null;
    private ExcelTemplate excelTemplate = null;
    private LinkedHashMap<String, IInputReader> mapReader = null;

    public WorkbookReader(Workbook workbook, ExcelTemplate excelTemplate) {
        this.workbook = workbook;
        this.excelTemplate = excelTemplate;
        this.mapReader = new LinkedHashMap();
        this.init();
    }

    private void init() {
        for (ExcelTemplateSheet excelTemplateSheet : this.excelTemplate.getTemplateSheets()) {
            String string = excelTemplateSheet.getSheetName();
            Sheet sheet = this.workbook.getSheet(string);
            this.mapReader.put(string, new SheetReader(sheet, excelTemplateSheet));
        }
    }

    @Override
    public Object getValue(String object, int n, int n2, ExcelProcessContext excelProcessContext) {
        if ((object = this.mapReader.get(object)) == null) {
            return null;
        }
        return object.getValue(n, n2, excelProcessContext);
    }

    @Override
    public boolean isEmptySheetRow(String object, int n) {
        if ((object = this.mapReader.get(object)) == null) {
            return true;
        }
        return object.isEmptySheetRow(n);
    }

    @Override
    public int getLastRowNum(String object) {
        if ((object = this.mapReader.get(object)) == null) {
            return 0;
        }
        return object.getLastRowNum();
    }

    @Override
    public IInputReader getSheetReader(String string) {
        return this.mapReader.get(string);
    }

    @Override
    public boolean isEmptyTableRow(String object, String string, int n) {
        if ((object = this.mapReader.get(object)) == null) {
            return true;
        }
        return object.isEmptyTableRow(string, n);
    }

    public void getLastCellIndex(String string, int n) {
        this.mapReader.get(string);
    }

    @Override
    public int getLastCellNum(String string, int n) {
        return this.mapReader.get(string).getLastCellNum(n);
    }
}

