/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.input.doc.in;

import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutTable;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.IInputRowAction;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;

public class InTable4Normal
implements IInTable {
    private int startRowIndex;
    private int endRowIndex;
    private ExcelTemplateTable templateTable = null;
    private IInputReaderBag workbookReader = null;

    public InTable4Normal(ExcelTemplateTable excelTemplateTable, int n, int n2, IInputReaderBag iInputReaderBag) {
        this.templateTable = excelTemplateTable;
        this.startRowIndex = n;
        this.endRowIndex = n2;
        this.workbookReader = iInputReaderBag;
    }

    public ExcelTemplateTable getTemplateTable() {
        return this.templateTable;
    }

    @Override
    public String getKey() {
        return this.templateTable.getTableKey();
    }

    private int getEndRow() {
        if (this.templateTable.isDtlTable()) {
            return this.endRowIndex;
        }
        return this.startRowIndex;
    }

    @Override
    public Object getValue(int n, int n2, ExcelProcessContext excelProcessContext) {
        return this.workbookReader.getValue(this.templateTable.getSheetName(), n, n2, excelProcessContext);
    }

    @Override
    public void doInputRowAction(OutTable outTable, IInputRowAction iInputRowAction, ExcelProcessContext excelProcessContext) throws Throwable {
        if (excelProcessContext.getMetaDataObject().getMetaTable(this.getKey()).isHead()) {
            iInputRowAction.doAction(this.getStartRowIndex(), this, outTable, this.templateTable, excelProcessContext);
            return;
        }
        for (int i = this.getStartRowIndex(); i <= this.getEndRow(); ++i) {
            iInputRowAction.doAction(i, this, outTable, this.templateTable, excelProcessContext);
        }
    }

    @Override
    public int getStartRowIndex() {
        return this.startRowIndex;
    }

    @Override
    public boolean isEmptySheetRow(String string, int n) {
        return this.workbookReader.isEmptySheetRow(string, n);
    }

    @Override
    public boolean isEmptyTableRow(String string, String string2, int n) {
        return this.workbookReader.isEmptyTableRow(string, string2, n);
    }
}

