/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.input.doc.in;

import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutTable;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.IInputRowAction;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import java.util.ArrayList;
import java.util.List;

public class InTable4MultiBatch
implements IInTable {
    private List<Integer> listRows = new ArrayList<Integer>();
    private ExcelTemplateTable templateTable = null;
    private IInputReaderBag workbookReader = null;

    public InTable4MultiBatch(ExcelTemplateTable excelTemplateTable, IInputReaderBag iInputReaderBag) {
        this.templateTable = excelTemplateTable;
        this.workbookReader = iInputReaderBag;
    }

    public ExcelTemplateTable getTemplateTable() {
        return this.templateTable;
    }

    @Override
    public String getKey() {
        return this.templateTable.getTableKey();
    }

    @Override
    public Object getValue(int n, int n2, ExcelProcessContext excelProcessContext) {
        return this.workbookReader.getValue(this.templateTable.getSheetName(), n, n2, excelProcessContext);
    }

    public void addRowNum(int n) {
        if (!this.listRows.contains(n)) {
            this.listRows.add(n);
        }
    }

    @Override
    public void doInputRowAction(OutTable outTable, IInputRowAction iInputRowAction, ExcelProcessContext excelProcessContext) throws Throwable {
        for (Integer n : this.listRows) {
            iInputRowAction.doAction(n, this, outTable, this.templateTable, excelProcessContext);
        }
    }

    @Override
    public int getStartRowIndex() {
        if (this.listRows.size() == 0) {
            return 0;
        }
        return this.listRows.get(0);
    }

    @Override
    public boolean isEmptySheetRow(String string, int n) {
        return this.workbookReader.isEmptySheetRow(string, n);
    }

    @Override
    public boolean isEmptyTableRow(String string, String string2, int n) {
        return this.workbookReader.isEmptyTableRow(string, string2, n);
    }
}

