/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.csv.cmd.normal;

import com.bokesoft.yes.common.util.ConstUtil;
import com.bokesoft.yes.csv.cmd.normal.CSVUtil;
import com.bokesoft.yes.excel.datatransfer.DataTransferUtil;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaParameter;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.LoadFormData;
import com.bokesoft.yigo.mid.util.DocumentUtil;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.document.TableFilterDetail;
import com.bokesoft.yigo.util.ExcelUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ExportCSV {
    private static String EndingSymbol = "\n";
    private DefaultContext context = null;
    private Document document = null;
    private MetaForm metaForm = null;
    private String exportTable = null;
    private FilterMap filterMap = null;
    private ConditionParas condParameters = null;
    private boolean onlyCurrentPage = false;
    private String postExportServiceName = null;
    private String exportFileName = null;
    private boolean needDownload = false;

    public ExportCSV(DefaultContext defaultContext, Document document, FilterMap filterMap, ConditionParas conditionParas, MetaForm metaForm, String string, boolean bl, String string2, String string3, boolean bl2) {
        this.context = defaultContext;
        this.document = document;
        this.filterMap = filterMap;
        this.metaForm = metaForm;
        this.exportTable = string;
        this.condParameters = conditionParas;
        this.onlyCurrentPage = bl;
        this.postExportServiceName = string2;
        this.exportFileName = string3;
        this.needDownload = bl2;
    }

    /*
     * Loose catch block
     */
    public FileData export() throws Throwable {
        Document document;
        Object object2222222222;
        File file;
        block32: {
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            file = null;
            if (this.document == null) {
                return null;
            }
            String string = SvrInfo.getWorkDir();
            string = string + File.separator + "CSV" + File.separator + this.metaForm.getKey() + System.currentTimeMillis() + ".CSV";
            MetaDataObject metaDataObject = this.metaForm.getDataSource().getDataObject();
            boolean bl = this.exportTable == null || this.exportTable.isEmpty();
            ArrayList<MetaTable> arrayList = new ArrayList<MetaTable>();
            if (bl) {
                Iterator iterator = metaDataObject.getTableCollection().iterator();
                while (iterator.hasNext()) {
                    arrayList.add((MetaTable)iterator.next());
                }
            } else {
                for (Object object2222222222 : this.exportTable.split(",")) {
                    MetaTable metaTable = metaDataObject.getTable((String)object2222222222);
                    if (metaTable == null) continue;
                    arrayList.add(metaTable);
                }
            }
            if (arrayList.size() == 0) {
                return new FileData();
            }
            boolean bl2 = DocumentUtil.isPaginationForm((MetaForm)this.metaForm, arrayList.iterator());
            document = this.document;
            if (bl2 && !this.onlyCurrentPage) {
                ExportCSV exportCSV = this;
                exportCSV.processParameter(exportCSV.context, arrayList);
                this.filterMap.setUseCursor(true);
                for (Object object2222222222 : this.filterMap.values()) {
                    if (object2222222222 == null) continue;
                    object2222222222.setMaxRows(0);
                }
                document = new LoadFormData(this.metaForm.getKey(), this.filterMap, this.condParameters).load(this.context, null);
            } else {
                for (MetaTable metaTable : arrayList) {
                    document.get(metaTable.getKey()).beforeFirst();
                }
            }
            file = new File(string);
            Iterator iterator = file.getParentFile();
            if (iterator != null) {
                ((File)((Object)iterator)).mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(file, true);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "gbk");
            for (MetaTable metaTable : arrayList) {
                DataTable dataTable = document.get(metaTable.getKey());
                this.exportTable(outputStreamWriter, this.metaForm, metaTable, dataTable);
            }
            try {
                outputStreamWriter.close();
                fileOutputStream.close();
                if (bl2) {
                    document.close();
                }
                break block32;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block32;
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                }
                catch (Throwable throwable2) {
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        if (bl2) {
                            document.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    throw throwable2;
                }
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (bl2) {
                        document.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        this.context.setDocument(document);
        new FileData();
        FileData fileData = ExcelFileUtil.convertCsvToFileData(this.metaForm.getKey(), this.exportFileName, file);
        object2222222222 = ExcelUtils.getPostExtProcess(this.context, this.postExportServiceName);
        if (object2222222222 != null) {
            object2222222222.process(this.context, fileData);
        }
        if (this.needDownload) {
            return fileData;
        }
        return new FileData();
    }

    private void exportTable(OutputStreamWriter outputStreamWriter, MetaForm metaForm, MetaTable metaTable, DataTable dataTable) throws Throwable {
        switch (metaTable.getTableMode()) {
            case 0: {
                this.exportHeadTable(outputStreamWriter, metaForm, metaTable, dataTable);
                return;
            }
            case 1: {
                this.exportDetailTable(outputStreamWriter, metaForm, metaTable, dataTable);
            }
        }
    }

    private void exportDetailTable(OutputStreamWriter outputStreamWriter, MetaForm metaForm, MetaTable metaTable, DataTable dataTable) throws Throwable {
        String string = metaTable.getKey();
        if ((string = metaForm.findComponentByTable(string)) == null) {
            return;
        }
        switch (string.getControlType()) {
            case 217: {
                this.exportGridTable(outputStreamWriter, metaForm, (MetaGrid)string, metaTable, dataTable);
                return;
            }
            case 216: {
                this.exportListViewTable(outputStreamWriter, metaForm, (MetaListView)string, metaTable, dataTable);
                return;
            }
            case 305: {
                this.exportEditViewTable(outputStreamWriter, metaForm, (MetaEditView)string, metaTable, dataTable);
            }
        }
    }

    private void exportListViewTable(OutputStreamWriter outputStreamWriter, MetaForm metaForm, MetaListView object2, MetaTable metaTable, DataTable dataTable) throws Throwable {
        HashMap<String, MetaListView> hashMap = new HashMap<String, MetaListView>();
        for (Object object2 : object2.getColumnCollection()) {
            hashMap.put(object2.getDataColumnKey(), (MetaListView)object2);
        }
        String string = "";
        String string2 = "";
        int n = 0;
        while (dataTable.next(true)) {
            for (Iterator iterator : metaTable) {
                String string3 = iterator.getKey();
                object2 = (MetaListViewColumn)hashMap.get(string3);
                if (object2 == null) continue;
                object2 = DataTransferUtil.convertFieldValue(this.context, metaForm, object2.getColumnType(), object2.getProperties(), dataTable, string3);
                object2 = CSVUtil.convertCSVValue((MetaColumn)iterator, TypeConvertor.toString((Object)object2));
                string2 = string2 + object2 + ",";
                if (n != 0) continue;
                string = string + CSVUtil.convertCSVValue(null, iterator.getCaption()) + ",";
            }
            if (n == 0) {
                outputStreamWriter.append(string + EndingSymbol);
            }
            outputStreamWriter.append(string2 + EndingSymbol);
            string2 = "";
            ++n;
        }
        if (string.isEmpty()) {
            for (Iterator iterator : metaTable) {
                if (!hashMap.containsKey(iterator.getKey())) continue;
                string = string + CSVUtil.convertCSVValue(null, iterator.getCaption()) + ",";
            }
            outputStreamWriter.append(string + EndingSymbol);
        }
        outputStreamWriter.append(EndingSymbol + EndingSymbol);
    }

    private void exportEditViewTable(OutputStreamWriter outputStreamWriter, MetaForm metaForm, MetaEditView object2, MetaTable metaTable, DataTable dataTable) throws Throwable {
        HashMap<String, MetaEditView> hashMap = new HashMap<String, MetaEditView>();
        for (Object object2 : object2.getColumnCollection()) {
            hashMap.put(object2.getDataColumnKey(), (MetaEditView)object2);
        }
        String string = "";
        String string2 = "";
        int n = 0;
        while (dataTable.next(true)) {
            for (Iterator iterator : metaTable) {
                String string3 = iterator.getKey();
                object2 = (MetaEditViewColumn)hashMap.get(string3);
                if (object2 == null) continue;
                object2 = DataTransferUtil.convertFieldValue(this.context, metaForm, object2.getColumnType(), object2.getProperties(), dataTable, string3);
                object2 = CSVUtil.convertCSVValue((MetaColumn)iterator, TypeConvertor.toString((Object)object2));
                string2 = string2 + object2 + ",";
                if (n != 0) continue;
                string = string + CSVUtil.convertCSVValue(null, iterator.getCaption()) + ",";
            }
            if (n == 0) {
                outputStreamWriter.append(string + EndingSymbol);
            }
            outputStreamWriter.append(string2 + EndingSymbol);
            string2 = "";
            ++n;
        }
        if (string.isEmpty()) {
            for (Iterator iterator : metaTable) {
                if (!hashMap.containsKey(iterator.getKey())) continue;
                string = string + CSVUtil.convertCSVValue(null, iterator.getCaption()) + ",";
            }
            outputStreamWriter.append(string + EndingSymbol);
        }
        outputStreamWriter.append(EndingSymbol + EndingSymbol);
    }

    private void exportGridTable(OutputStreamWriter outputStreamWriter, MetaForm metaForm, MetaGrid object, MetaTable metaTable, DataTable dataTable) throws Throwable {
        String string2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : object.getRowCollection()) {
            if (string2.getRowType() != 2) continue;
            Iterator iterator = string2.iterator();
            while (iterator.hasNext()) {
                string2 = (MetaGridCell)iterator.next();
                if (!metaTable.getKey().equals(string2.getTableKey())) continue;
                hashMap.put(string2.getColumnKey(), string2);
            }
        }
        string2 = "";
        String string3 = "";
        int n = 0;
        while (dataTable.next(true)) {
            for (Iterator iterator : metaTable) {
                object = iterator.getKey();
                MetaGridCell metaGridCell = (MetaGridCell)hashMap.get(object);
                if (metaGridCell == null) continue;
                object = DataTransferUtil.convertFieldValue(this.context, metaForm, metaGridCell.getCellType(), metaGridCell.getProperties(), dataTable, (String)object);
                object = CSVUtil.convertCSVValue((MetaColumn)iterator, TypeConvertor.toString((Object)object));
                string3 = string3 + object + ",";
                if (n != 0) continue;
                string2 = string2 + CSVUtil.convertCSVValue(null, iterator.getCaption()) + ",";
            }
            if (n == 0) {
                outputStreamWriter.append(string2 + EndingSymbol);
            }
            outputStreamWriter.append(string3 + EndingSymbol);
            string3 = "";
            ++n;
        }
        if (string2.isEmpty()) {
            for (Iterator iterator : metaTable) {
                if (!hashMap.containsKey(iterator.getKey())) continue;
                string2 = string2 + CSVUtil.convertCSVValue(null, iterator.getCaption()) + ",";
            }
            outputStreamWriter.append(string2 + EndingSymbol);
        }
        outputStreamWriter.append(string3 + EndingSymbol + EndingSymbol);
    }

    private void exportHeadTable(OutputStreamWriter outputStreamWriter, MetaForm metaForm, MetaTable object, DataTable dataTable) throws Throwable {
        HashMap<String, MetaComponent> hashMap = new HashMap<String, MetaComponent>();
        for (MetaComponent metaComponent : metaForm.getAllComponents()) {
            if (!object.getKey().equals(metaComponent.getTableKey())) continue;
            hashMap.put(metaComponent.getColumnKey(), metaComponent);
        }
        Object object2 = "";
        String string = "";
        dataTable.next(true);
        for (MetaColumn metaColumn : object) {
            MetaComponent metaComponent;
            object = metaColumn.getKey();
            metaComponent = (MetaComponent)hashMap.get(object);
            if (metaComponent == null) continue;
            object = DataTransferUtil.convertFieldValue(this.context, metaForm, metaComponent.getControlType(), metaComponent.getProperties(), dataTable, (String)object);
            object = CSVUtil.convertCSVValue(metaColumn, TypeConvertor.toString((Object)object));
            string = string + object + ",";
            object2 = (String)object2 + CSVUtil.convertCSVValue(null, metaColumn.getCaption()) + ",";
        }
        outputStreamWriter.append((String)object2 + EndingSymbol);
        outputStreamWriter.append(string + EndingSymbol);
        outputStreamWriter.append(EndingSymbol + EndingSymbol);
    }

    private void processParameter(DefaultContext defaultContext, ArrayList<MetaTable> object) throws Throwable {
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            Object object2 = (MetaTable)object.next();
            Object object3 = object2.getParameterCollection();
            if (object3 == null) continue;
            TableFilterDetail tableFilterDetail = (TableFilterDetail)this.filterMap.get((Object)object2.getKey());
            if (tableFilterDetail == null) {
                tableFilterDetail = new TableFilterDetail(object2.getKey());
                this.filterMap.put((Object)object2.getKey(), (Object)tableFilterDetail);
            }
            object2 = new ArrayList();
            object3 = object3.iterator();
            while (object3.hasNext()) {
                MetaParameter metaParameter = (MetaParameter)object3.next();
                if (metaParameter.getSourceType() == 0) {
                    ((ArrayList)object2).add(ConstUtil.getValue((String)metaParameter.getValue(), (int)metaParameter.getDataType()));
                    continue;
                }
                if (metaParameter.getSourceType() == 1) {
                    Object object4 = defaultContext.getMidParser().eval(0, metaParameter.getFormula());
                    if (metaParameter.getDataType() != -1) {
                        object4 = TypeConvertor.toDataType((int)metaParameter.getDataType(), (Object)object4);
                    }
                    ((ArrayList)object2).add(object4);
                    continue;
                }
                ((ArrayList)object2).add(null);
            }
            tableFilterDetail.setParaValues((ArrayList)object2);
        }
    }
}

