package com.bokesoft.yigo.print;

import com.bokesoft.yes.report.MidQueryProxy;
import com.bokesoft.yes.report.MidReportResourceResolver;
import com.bokesoft.yes.report.ReportDataSource;
import com.bokesoft.yes.report.datasource.IImplReportDataSource;
import com.bokesoft.yes.report.fill.FillPolicy;
import com.bokesoft.yes.report.output.OutputPageSet;
import com.bokesoft.yes.report.print.PrintImpl;
import com.bokesoft.yigo.common.ui.AbstractRuntimeUIConfig;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.report.MetaReportProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.usrpara.Paras;
import com.bokesoft.yigo.tools.ve.VE;

/**
 * 中间层打印API，用于直接传递打印机名称来实现打印
 * @author wangyh
 *
 */
public class Print {
	/** 中间层默认上下文 */
	private DefaultContext context = null;
	/** 表单标识 */
	private String formKey = null;
	/** 报表标识 */
	private String reportKey = null;
	/** 数据对象文档 */
	private Document document = null;
	/** 参数集 */
	private Paras paras = null;
	/** 是否套打标志 */
	private boolean fillEmptyPrint = false;
	
	/**
	 * 使用参数构造打印对象
	 * @param context 默认上下文
	 * @param formKey 表单标识
	 * @param reportKey 报表标识
	 * @param document 数据对象文档
	 * @param paras 参数集
	 * @param fillEmptyPrint 套打标志
	 */
	public Print(DefaultContext context, String formKey, String reportKey, Document document, Paras paras, 
			boolean fillEmptyPrint) {
		this.context = context;
		this.formKey = formKey;
		this.reportKey = reportKey;
		this.document = document;
		this.paras = paras;
		this.fillEmptyPrint = fillEmptyPrint;
	}
	
	/**
	 * 打印
	 * @param printerName 打印机名称
	 * @param useDefault 如果取不到打印机，是否使用默认打印机标志
	 * @throws Throwable 打印过程中的可能错误
	 */
	public void print(String printerName, boolean useDefault, AbstractRuntimeUIConfig runtimeUIConfig) throws Throwable {
		OutputPageSet pageSet = new OutputPageSet();
		VE ve = context.getVE();
		MidQueryProxy queryProxy = new MidQueryProxy(this.context, formKey);
		IImplReportDataSource dataSource = new ReportDataSource(ve, queryProxy, document, paras, formKey, runtimeUIConfig, context.getDictCache());
		IMetaFactory metaFactory = ve.getMetaFactory();
		MetaReport metaReport = metaFactory.getReport("", this.formKey, reportKey);
		FillPolicy policy = new FillPolicy(metaReport, dataSource);
		policy.fill(pageSet);
		
		MidReportResourceResolver resolver = new MidReportResourceResolver(ve, this.formKey, metaReport.getProjectKey());
		PrintImpl impl = new PrintImpl(resolver, pageSet, this.fillEmptyPrint);
		impl.printImpl(printerName, useDefault);
	}
}
