package com.bokesoft.yigo.excel;

import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
/**
 * 导出二次开发服务接口,实现此接口以完成自定义的导出要求
 * 
 * @author 陈瑞
 *
 */
public interface IExportService {
	/**
	 * 导出方法,调用ExcelUtil.writeExcel方法将导出的文件写入指定位置并返回文件路径,
	 * @param context 上下文,包含formKey
	 * @param filterMap 过滤条件
	 * @param condParameters 查询参数集
	 * @param exportTables 导出表名称,","分割
	 * @param postEServiceName 导出后服务名称
	 * @param onlyCurrentPage 是否导出当前页
	 * @return 导出文件路径(绝对路径)
	 * @throws Throwable 可能发生的异常
	 */
	public FileData exportData(DefaultContext context,Document document, FilterMap filterMap, ConditionParas condParameters,String exportTables, String postEServiceName,boolean onlyCurrentPage, String exportFileName, boolean needDownload) throws Throwable; 
}