package com.bokesoft.yes.excel.utils;

import com.bokesoft.yes.excel.cmd.normal.ExportExcelWithMultiPageTemplate;
import com.bokesoft.yes.excel.cmd.normal.ExportExcelWithTemplate;
import com.bokesoft.yes.excel.cmd.normal.IExport;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;

/**
 * 根据模板导出的工厂类 
 *
 */
public class ExportExcelFactory {
	/**
	 * 根据模板类型，返回适合的导出类
	 * @param context 上下文环境
	 * @param workBook Excel模板配置对象
	 * @param document 要导出的默认数据集
	 * @param filterMap 重新加载数据的OID条件
	 * @param condParameters 重新加载数据的过滤条件
	 * @return 导出类
	 * @throws Throwable
	 */
	public static IExport create(DefaultContext context, MetaExcelWorkbook workBook, Document document, FilterMap filterMap, ConditionParas condParameters,
			String postExportServerName, String exportFileName,boolean needDownload) throws Throwable {
		IExport export = null;
		if (workBook.isNeedLoadData()) {
			export = new ExportExcelWithMultiPageTemplate(context, workBook, filterMap, condParameters, postExportServerName,exportFileName);
		} else {
			export = new ExportExcelWithTemplate(context, workBook, document, postExportServerName,exportFileName,needDownload);
		}

		return export;
	}
}