package com.bokesoft.yes.excel.utils;

import java.util.List;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.tools.dict.IDictCache;
import com.bokesoft.yigo.tools.ve.VE;

public class DictColumnUtil {
	
	public static List<MetaColumn>  getDictDisplayColumns(VE ve, AbstractMetaObject properties) throws Throwable {
		MetaDictProperties dp = (MetaDictProperties)properties;
		MetaDataObject dictDataObject = ve.getGlobalEnv().getMetaFactory().getDataObject(dp.getItemKey());
		if(dictDataObject == null){
			return null;
		}
		return dictDataObject.getDisplayColumns();
	}

    public static Object getDictItemValue(DefaultContext context, String itemKey, String columnKey, Object dictID) throws Throwable{
		IDictCache dictCache = context.getDictCache();
		long id = TypeConvertor.toLong(dictID);
		Item item = dictCache.getItem(itemKey, id);
		return item != null ? item.getValue(columnKey) : null;
	}
	
	public static boolean needExpandDictColumn(MetaGridCell metaCell){
		if (metaCell.getCellType() == ControlType.DICT){
			MetaDictProperties dp = (MetaDictProperties)metaCell.getProperties();
			if (!dp.isAllowMultiSelection()){
				return true;
			}
		}
		return false;
	}
}
