package com.bokesoft.yes.excel.transformer;

import java.util.List;

import com.bokesoft.yes.common.util.BaseTypeUtil;
import com.bokesoft.yes.common.util.CompareUtil;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yes.excel.template.ExcelFormat;
import com.bokesoft.yes.excel.template.ExcelListItem;
import com.bokesoft.yigo.common.util.TypeConvertor;

public class ExcelListDataTransformer implements IExcelTransformer {

	@Override
	public Object transform(ExcelCell cell, Object value) {
		Object result = value;
		ExcelDisplay display = cell.getDisplay();
		if ( display != null ) {
			ExcelFormat format = display.getFormat();
			if ( format != null ) {
				result = transform(format.getDataType(), format.getItemKey(),
						format.getFieldKeys(), format.getFormatString(), format.getListItems(), value);
			}
		}
		return result;
	}
	
	@Override
	public Object transform(int dataType, String itemKey, String fieldKeys, String formatString,
			List<ExcelListItem> listItems, Object value) {
		Object result = getText(listItems, value);
		if ( formatString != null && !formatString.isEmpty() ) {
			IDataFormatter formatter = FormatterManager.getDataFormatter(dataType);
			result = formatter.format(value, formatString);
		}
		return result;
	}

	private String getText(List<ExcelListItem> listItems, Object value) {
		if(value == null || listItems == null)
			return "";
		
		for(ExcelListItem item : listItems) {
			int type = BaseTypeUtil.getType(value);
			if ( CompareUtil.compare(value, TypeConvertor.toJavaType(type, item.getValue())) == 0) {
				return item.getText();
			}
		}
		return "";
	}

}
