package com.bokesoft.yes.excel.template;

import com.bokesoft.yigo.meta.exceltemplate.MetaExcelFont;

public class ExcelFont {
	/** 名称 */
	private String name = "宋体";
	/** 大小 */
	private short size = 12;
	/** 粗体 */
	private boolean bold = false;
	/** 斜体 */
	private boolean italic = false;

	private ExcelFont(){}
	
	public ExcelFont(MetaExcelFont font) {
		this.name = font.getName();
		this.size = font.getSize();
		this.bold = font.isBold();
		this.italic = font.isItalic();
	}
	
	/**
	 * 设置名称
	 * 
	 * @param name
	 *            名称
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * 取得名称
	 * 
	 * @return 名称
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * 设置大小
	 * 
	 * @param size
	 *            大小
	 */
	public void setSize(short size) {
		this.size = size;
	}

	/**
	 * 取得大小
	 * 
	 * @return 大小
	 */
	public short getSize() {
		return this.size;
	}

	/**
	 * 设置粗体
	 * 
	 * @param bold
	 *            粗体标志
	 */
	public void setBold(boolean bold) {
		this.bold = bold;
	}

	/**
	 * 取得粗体
	 * 
	 * @return 粗体标志
	 */
	public boolean isBold() {
		return this.bold;
	}

	/**
	 * 设置斜体
	 * 
	 * @param italic
	 *            斜体标志
	 */
	public void setItalic(boolean italic) {
		this.italic = italic;
	}

	/**
	 * 取得斜体
	 * 
	 * @return 斜体标志
	 */
	public boolean isItalic() {
		return this.italic;
	}

	public ExcelFont clone() {
		ExcelFont newObject = new ExcelFont();
		newObject.setName(name);
		newObject.setSize(size);
		newObject.setBold(bold);
		newObject.setItalic(italic);

		return newObject;
	}
	
	public String createStyleKey() {
		String key = name+"#"+size+"#"+bold+"#"+italic;
		return key;
	}
}
