package com.bokesoft.yes.excel.template;

import java.util.ArrayList;
import java.util.Iterator;

import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateCellType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;

public class ExcelCell {
	/** 单元格列号*/
	private int cellIndex = -1;
	/** 单元格行号*/
	private int rowIndex = -1;
	/** 单元格取值类型*/
	private String sourceType = "Field";
	/** 单元格取值公式*/
	private String definition = "";
	/** 占用列数*/
	private int mergedColumnSpan = 0;
	/** 占用行数*/
	private int mergedRowSpan = 0;
	/** 是否扩展单元格*/
	private boolean isColumnExpand = false;
	/** 单元格扩展信息*/
	private ExcelColumnExpand columnExpand = null;
	/** 是否扩展目标单元格*/
	private boolean columnExpandTarget = false;
	/** 扩展单元格关键字信息*/
	private ArrayList<ColumnExpandItem> columnExpandItemArray = null;
	
	private ExcelDisplay display = null;
	
	/** 扩展单元格的显示值*/
	private String expandCaption = null;

	/** 扩展单元格的值*/
	private Object expandValue = -1;
	/** 单元格字段对应的数据源表标志*/
	private String tableKey = "";
	/** 忽略导出(表达式)  */
	private String ignoreExport = "";
	
	private boolean isExcelFormula = false;
	/** Excel表达式对应表单明细key  */
	private String excelFormulaKey = "";
	
	public boolean need = true;
	public ExcelCell() {
		
	}
	
	public ExcelCell(MetaExcelCell metaExcelCell, int rowIndex) {
		this.rowIndex = rowIndex;
		cellIndex = metaExcelCell.getCellIndex();
		sourceType = ExcelTemplateCellType.toString(metaExcelCell.getSourceType());
		definition = metaExcelCell.getDefinition();
		mergedColumnSpan = metaExcelCell.getMergedColumnSpan();
		mergedRowSpan = metaExcelCell.getMergedRowSpan();
		isColumnExpand = metaExcelCell.isColumnExpand();
		tableKey = metaExcelCell.getTableKey();
		ignoreExport = metaExcelCell.getIgnoreExport();
		if (metaExcelCell.getColumnExpand() != null) {
			columnExpand = new ExcelColumnExpand(metaExcelCell.getColumnExpand());
		}
		
		if (metaExcelCell.getDisplay() != null) {
			display = new ExcelDisplay(metaExcelCell.getDisplay());
		}
	}

	public int getCellIndex() {
		return cellIndex;
	}

	public String getSourceType() {
		return sourceType;
	}

	public String getDefinition() {
		return definition;
	}

	public int getMergedColumnSpan() {
		return mergedColumnSpan;
	}

	public int getMergedRowSpan() {
		return mergedRowSpan;
	}

	public boolean isColumnExpand() {
		return isColumnExpand;
	}

	public ExcelColumnExpand getColumnExpand() {
		return columnExpand;
	}

	public void setCellIndex(int cellIndex) {
		this.cellIndex = cellIndex;
	}

	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}

	public void setDefinition(String definition) {
		this.definition = definition;
	}

	public void setMergedColumnSpan(int mergedColumnSpan) {
		this.mergedColumnSpan = mergedColumnSpan;
	}

	public void setMergedRowSpan(int mergedRowSpan) {
		this.mergedRowSpan = mergedRowSpan;
	}

	public void setIsColumnExpand(boolean isColumnExpand) {
		this.isColumnExpand = isColumnExpand;
	}

	public void setColumnExpand(ExcelColumnExpand columnExpand) {
		this.columnExpand = columnExpand;
	}

	public void setColumnExpandTarget(boolean columnExpandTarget) {
		this.columnExpandTarget = columnExpandTarget;
	}

	public boolean getColumnExpandTarget() {
		return columnExpandTarget;
	}

	public void addColumnExpandItem(ColumnExpandItem item) {
		if (this.columnExpandItemArray == null) {
			this.columnExpandItemArray = new ArrayList<ColumnExpandItem>();
		}
		this.columnExpandItemArray.add(item);
	}

	public ArrayList<ColumnExpandItem> getColumnExpandItems() {
		return columnExpandItemArray;
	}
	
	public int getRowIndex() {
		return rowIndex;
	}

	public void setRowIndex(int rowIndex) {
		this.rowIndex = rowIndex;
	}
	public String getExpandCaption() {
		return expandCaption;
	}

	public Object getExpandValue() {
		return expandValue;
	}

	public void setExpandCaption(String expandCaption) {
		this.expandCaption = expandCaption;
	}

	public void setExpandValue(Object expandValue) {
		this.expandValue = expandValue;
	}
	public ExcelDisplay getDisplay() {
		return display;
	}

	public void setDisplay(ExcelDisplay display) {
		this.display = display;
	}

	public String getTableKey() {
		return tableKey;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	public String getIgnoreExport() {
		return this.ignoreExport;
	}
	
	public void setExcelFormula(boolean isExcelFormula) {
		this.isExcelFormula = isExcelFormula;
	}

	public boolean isExcelFormula() {
		return isExcelFormula;
	}
	
	public String getExcelFormulaKey() {
		return excelFormulaKey;
	}

	public void setExcelFormulaKey(String excelFormulaKey) {
		this.excelFormulaKey = excelFormulaKey;
	}


	public ExcelCell clone() {
		ExcelCell excelCell = new ExcelCell();
		excelCell.setExpandCaption(expandCaption);
		excelCell.setExpandValue(expandValue);
		excelCell.setCellIndex(cellIndex);
		excelCell.setIsColumnExpand(isColumnExpand);
		excelCell.setColumnExpandTarget(columnExpandTarget);
		excelCell.setDefinition(definition);
		excelCell.setMergedColumnSpan(mergedColumnSpan);
		excelCell.setMergedRowSpan(mergedRowSpan);
		excelCell.setRowIndex(rowIndex);
		excelCell.setSourceType(sourceType);
		excelCell.setTableKey(tableKey);
		excelCell.setExcelFormulaKey(excelFormulaKey);
		excelCell.setExcelFormula(isExcelFormula);
		excelCell.setColumnExpand(columnExpand == null ? null : columnExpand.clone());
		excelCell.setDisplay(display == null ? null : display.clone());
		if ( this.columnExpandItemArray != null ) {
			ColumnExpandItem columnExpandItem = null;
			Iterator<ColumnExpandItem> it = columnExpandItemArray.iterator();
			while ( it.hasNext() ) {
				columnExpandItem = it.next();
				excelCell.addColumnExpandItem(columnExpandItem.clone());
			}
		}
		return excelCell;
	}
}
