package com.bokesoft.yes.excel.parser;

import java.util.ArrayList;
import java.util.HashMap;

import com.bokesoft.yes.excel.document.ExcelDataTable;
import com.bokesoft.yes.excel.document.ExcelDetailDataRow;
import com.bokesoft.yes.excel.document.ExcelExpandDataRow;
import com.bokesoft.yes.excel.document.IExcelDataRow;
import com.bokesoft.yes.excel.template.ExcelRow;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

public class ExcelContext extends DefaultContext {
	
	private ExcelExpandDataRow expandDataRow = null;
	private ExcelDetailDataRow detailDataRow = null;
	private DataTable dataTable = null;
	private ExcelRow excelRow = null;
	private MetaTable metaTable = null;
	private HashMap<String, ExcelDataTable> excelDataTableMap = null;
	private Document document = null;
	private int expandCount = 0;
	/** 分组行包含的明细行列表，用于计算分组行汇总值以及填充分组行的上一级分组字段*/
	private ArrayList<IExcelDataRow> detailRows = null;
	
	public ExcelContext(DefaultContext context) throws Throwable {
		super(context);
		if (context.getParas() != null) {
			this.ensureParas().fromJSON(context.getParas().toJSON());
		}
	}
	

	public void setExcelExpandDataRow(ExcelExpandDataRow expandDataRow) {
		this.expandDataRow = expandDataRow;
	}
	
	public ExcelExpandDataRow getExcelExpandDataRow() {
		return expandDataRow;
	}
	
	public void setDataTable(DataTable dataTable) {
		this.dataTable = dataTable;
	}
	
	public DataTable getDataTable() {
		return dataTable;
	}
	
	public void setExcelRow(ExcelRow excelRow) {
		this.excelRow = excelRow;
	}
	
	public ExcelRow getExcelRow() {
		return excelRow;
	}
	
	public void setMetaTable(MetaTable metaTable) {
		this.metaTable = metaTable;
	}
	
	public MetaTable getMetaTable() {
		return metaTable;
	}
	
	public void setExcelDataTableMap(HashMap<String, ExcelDataTable> excelDataTableMap) {
		this.excelDataTableMap = excelDataTableMap;
	}
	
	public HashMap<String, ExcelDataTable> getExcelDataTableMap() {
		return excelDataTableMap;
	}
	
	public void setDocument(Document document) {
		this.document = document;
	}
	
	public Document getDocument() {
		return document;
	}
	
	public void setExpandCount(int expandCount) {
		this.expandCount = expandCount;
	}
	
	public int getExpandCount() {
		return expandCount;
	}
	
	public void setExcelDetailDataRow(ExcelDetailDataRow detailDataRow) {
		this.detailDataRow = detailDataRow;
	}
	
	public ExcelDetailDataRow getExcelDetailDataRow() {
		return detailDataRow;
	}
	
	public void setDetailRows(ArrayList<IExcelDataRow> detailRows) {
		this.detailRows = detailRows;
	}
	
	public ArrayList<IExcelDataRow> getDetailRows(){
		return detailRows;
	}
}
