package com.bokesoft.yes.excel.document;

import com.bokesoft.yes.excel.template.ExcelRow;

/**
 * 记录Excel模板中的分组单元格的分组信息 以便计算
 * 
 * @author guowj
 */
public class GroupInfo {

	/** 分组级别*/
	private int groupLevel = 0;
	/** 分组行位置*/
	private String groupPosition = null;
	/** 头部分组行的个数*/
	private int groupHeadRowCount = 0;
	/** 尾部分组行的个数*/
	private int groupTailRowCount = 0;
	/** 单元格的取值内容*/
	private String definition = null;
	/** 分组行的模板*/
	private ExcelRow excelRow = null;
	
	public GroupInfo(int groupLevel) {
		this.groupLevel = groupLevel;
	}
	
	public void setGroupLevel(int groupLevel) {
		this.groupLevel = groupLevel;
	}

	public void setGroupPosition(String groupPosition) {
		this.groupPosition = groupPosition;
	}
	
	public String getGroupPosition() {
		return groupPosition;
	}
	
	public void setGroupHeadRowCount(int groupHeadRowCount) {
		this.groupHeadRowCount = groupHeadRowCount;
	}
	
	public int getGroupHeadRowCount() {
		return groupHeadRowCount;
	}
	
	public void setGroupTailRowCount(int groupTailRowCount) {
		this.groupTailRowCount = groupTailRowCount;
	}
	
	public int getGroupTailRowCount() {
		return groupTailRowCount;
	}
	
	public int getGroupLevel() {
		return groupLevel;
	}
	
	public void setDefinition(String definition) {
		this.definition = definition;
	}
	
	public String getDefinition() {
		return definition;
	}
	
	public void setExcelRow(ExcelRow excelRow) {
		this.excelRow = excelRow;
	}
	
	public ExcelRow getExcelRow() {
		return excelRow;
	}
}
