package com.bokesoft.yes.excel.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

import com.bokesoft.yes.common.struct.MultiKey;

public class ExcelDataTable {

	private ArrayList<IExcelDataRow> rowList = new ArrayList<IExcelDataRow>();

	private TreeMap<MultiKey, ExcelExpandDataRow> expandRows = new TreeMap<MultiKey, ExcelExpandDataRow>(MultiKey.newComparator());
	
	private TreeMap<MultiKey, ExcelGroupDataRow> groupRows = new TreeMap<MultiKey, ExcelGroupDataRow>(MultiKey.newComparator());
	private ArrayList<ExcelGroupDataRow> groupList = new ArrayList<ExcelGroupDataRow>();
	
	private HashMap<String, ExcelGroupDataRow> sortMap = null;
	private ArrayList<ExcelGroupDataRow> sortList = new ArrayList<ExcelGroupDataRow>();

	public ExcelDataTable() {

	}

	public void addDetailRow(ExcelDetailDataRow row) {
		rowList.add(row);
	}
	
	public void addGroupRow(ExcelGroupDataRow row) {
		rowList.add(row);
	}
	
	public void addAllDetailRow(ExcelGroupDataRow row) {
		Iterator<IExcelDataRow> rows = row.iterator();
		while(rows.hasNext()) {
			IExcelDataRow r = rows.next();
			rowList.add(r);
		}
	}

	public void addExpandDataRow(MultiKey key, ExcelExpandDataRow row) {
		if (!expandRows.containsKey(key)) {
			expandRows.put(key, row);
			rowList.add(row);
		}
	}
	
	public void addGroupDataRow(MultiKey key, ExcelGroupDataRow row) {
		if (!groupRows.containsKey(key)) {
			groupRows.put(key, row);
		}
	}
	
	public void addGroupDataRowToList(ExcelGroupDataRow row) {
		if(row != null) {
			groupList.add(row);
		}
	}
	
	public ArrayList<ExcelGroupDataRow> getGroupList(){
		return groupList;
	}

	public ExcelExpandDataRow getExpandRow(MultiKey key) {
		return expandRows.get(key);
	}
	
	public ExcelGroupDataRow getGroupRow(MultiKey key) {
		return groupRows.get(key);
	}
	
	public TreeMap<MultiKey, ExcelGroupDataRow> getGroupRows(){
		return groupRows;
	}
	
	public Iterator<IExcelDataRow> iterator() {
		return rowList.iterator();
	}
	
	public void setSortMap(HashMap<String, ExcelGroupDataRow> sortMap) {
		this.sortMap = sortMap;
	}
	
	public HashMap<String, ExcelGroupDataRow> getSortMap(){
		return sortMap;
	}
	
	public void setSortList(ArrayList<ExcelGroupDataRow> sortList) {
		this.sortList = sortList;
	}
	
	public ArrayList<ExcelGroupDataRow> getSortList(){
		return sortList;
	}
}
