package com.bokesoft.yes.excel.cmd.stamp.output.strategy;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputRowProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputSheetProcess;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.constants.ExcelTemplateConstants;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.excel.template.util.ExcelUtil;

public abstract class BaseOutputStrategy implements IOutputStrategy {
	
	protected Workbook workbook = null;
	
	private StampExcelStyleFactory styleFactory = null;
	
	protected Sheet curSheet = null;
	
	protected Sheet sysSheet = null;
	
	protected ExcelTemplateSheet curSheetTemplate = null;
	
	protected ExcelTemplate excelSheetTemplate = null;
	
	public BaseOutputStrategy(Workbook workbook, StampExcelStyleFactory styleFactory, ExcelTemplate excelSheetTemplate) {
		this.workbook = workbook;
		this.styleFactory = styleFactory;
		this.excelSheetTemplate = excelSheetTemplate;
		this.sysSheet = ExcelUtil.getSheet(workbook, ExcelTemplateConstants.YIGO_TEMPLATE);
	}

	@Override
	public void preOutputSheet(OutputSheetProcess exportSheetProcess) {
		curSheetTemplate = exportSheetProcess.getTemplateSheet();
		curSheet = ExcelUtil.getSheet(workbook, curSheetTemplate.getSheetName());
	};
	
	@Override
	public void insertRow(int rowIndex, OutputRowProcess exportRowProcess) {
		ExcelUtil.insertRow(curSheet, rowIndex);
	}

	protected void setCellValue(Object value, int rowIndex, int colIndex, ExcelTemplateField templateField) {
		ExcelUtil.setCellValue(curSheet, rowIndex, colIndex, value, templateField, styleFactory);
	}
}
