package com.bokesoft.yes.excel.cmd.stamp.output.process;

import java.math.BigDecimal;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.output.strategy.IOutputStrategy;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.transformer.ExcelTransformerFactory;
import com.bokesoft.yes.excel.transformer.IExcelTransformer;
import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateCellType;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.util.StampExcelUtil;

public class OutputRowProcess {
	
	private int addedDtlRowCount = 0;

	private ExcelTemplateTable templateTable = null;
	
	private Object linkedDetailValue = null;
	
	public OutputRowProcess() {
	}
	
	public void setTemplateTable(ExcelTemplateTable templateTable) {
		this.templateTable = templateTable;
	}
	
	public ExcelTemplateTable getTemplateTable() {
		return this.templateTable;
	}
	
	public void setLinkedDetailValue(Object linkedDetailValue) {
		this.linkedDetailValue = linkedDetailValue;
	}
	
	public void incAddedDtlRowCount() {
		addedDtlRowCount ++;
	}
	
	public void doProcess(DataTable dataTable, ExcelTransformerFactory transformerFactory,
			DefaultContext context, IOutputStrategy actionStrategy, boolean isLast, boolean isNeedResetCellIndex) throws Throwable {
		Object value = null;
		int rowIndex = addedDtlRowCount;
		int ignoreDtlFieldCount = 0;
		BigDecimal totalColumn = new BigDecimal(0);
		String totalColumnKey = "";
		if (templateTable == null) {
			return;
		}
		for (ExcelTemplateField field : templateTable.getFields()) {
			String s = field.getDefine();
			if(s != null && s.indexOf("SumExpand") != -1){
//				hasTotalColumn = true;
//				totalColumnKey = s.substring(11, s.length() - 2);
				field.setTotalColumnCell(true);
			}
		}
		for (ExcelTemplateField field : templateTable.getFields()) {
			boolean bIgnoreExport = isIgnoreExport(field, context);
			if (templateTable.isDtlTable() && bIgnoreExport) {
				ignoreDtlFieldCount ++;
				continue;
			}
			if (field == null) {
				continue;
			}
			int colIndex = (templateTable.isDtlTable() && isNeedResetCellIndex) ? 
					(field.getColIndex() - ignoreDtlFieldCount) : field.getColIndex();

			if (field.isDetailLinkField()) {
				actionStrategy.outputCell(linkedDetailValue, rowIndex, colIndex, field, templateTable.isDtlTable());
				continue;
			}
			switch (field.getSourceType()) {
			case ExcelTemplateCellType.Const:
				value = field.getDefine();
				break;
			case ExcelTemplateCellType.Field:
				value = dataTable.getObject(field.getDefine());
				break;
			case ExcelTemplateCellType.Formula:
				if (!field.isTotalRow()){
					value = context.getMidParser().eval(ScriptType.Formula, field.getDefine());
				}
				value = context.getMidParser().eval(ScriptType.Formula, field.getDefine());
				break;
			}
			
			//数值类型直接输出，通过cellstyle设置显示样式，否则会被输出成字符格式,后续excel中数据处理不方便
			if (!StampExcelUtil.isNumericCell(field.getDataType())) {
				IExcelTransformer transfer = transformerFactory.getTransformer(context, field.getDefine(), field.getDataType());
				value = transfer.transform(field.getDataType(), field.getItemKey(),
						field.getFieldKeys(), field.getFormatString(), field.getListItems(), value);
			}
			//计算汇总值
			if (field.isTotalColumnCell()){
				Object value1 = null;
				String s = field.getDefine();
				totalColumnKey = s.substring(11, s.length() - 2);
				for (ExcelTemplateField field1 : templateTable.getFields()) {
					if (field1.getDefine().indexOf(totalColumnKey) != -1 && field1.getDefine().indexOf("SumExpand") == -1){
						value1 = dataTable.getObject(field1.getDefine());
						totalColumn = totalColumn.add((BigDecimal)value1);
					}
				}
				value = totalColumn;
			}
			actionStrategy.outputCell(value, rowIndex, colIndex, field, templateTable.isDtlTable());
		}
		
		if (getTemplateTable().isDtlTable() && !isLast) {
			incAddedDtlRowCount();
			actionStrategy.insertRow(this.addedDtlRowCount, this);
		}
	}
	
	/**
	 * 单元格是否忽略导出
	 * @param field
	 * @param context
	 * @return
	 */
	private boolean isIgnoreExport(ExcelTemplateField field, DefaultContext context) {
		boolean bIgnoreExport = false;
		if (context.getMidParser() == null) {
			return bIgnoreExport;
		}
		try {
			bIgnoreExport = StringUtil.isBlankOrNull(field.getIgnoreExport()) ? false :
				TypeConvertor.toBoolean(context.getMidParser().eval(ScriptType.Formula, field.getIgnoreExport()));
		} catch (Throwable e) {
			e.printStackTrace();
		}
		return bIgnoreExport;
	}
}
