package com.bokesoft.yes.excel.cmd.stamp.input;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

import com.bokesoft.yes.excel.cmd.stamp.ImportExcelWithStamp;
import com.bokesoft.yigo.excel.IImportService2;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;

public class ImportExcelWithStampService implements IImportService2 {
	
	private String formKey = null;
	
	private boolean clearOriginalData = false;
	
	private String postServiceName = null;
	
	private Document document = null;
	
	public ImportExcelWithStampService(Document document) {
		this.document = document;
	}
	
	@Override
	public Object importData(DefaultContext context, byte[] bytes) throws Throwable {
		DefaultContext newContext = new DefaultContext(context);
		newContext.setParas(context.getParas());
		newContext.setFormKey(formKey);
		
		InputStream is = new ByteArrayInputStream(bytes);
		Workbook workbook = WorkbookFactory.create(is);
		ImportExcelWithStamp importData = new ImportExcelWithStamp(context, workbook, document, postServiceName);
		return importData.importData();
	}

	@Override
	public void setClearOriginalData(boolean clearOriginalData) {
		this.clearOriginalData = clearOriginalData;
	}

	@Override
	public void setPostServiceName(String postServiceName) {
		this.postServiceName = postServiceName;
	}

	@Override
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}

}
