package com.bokesoft.yes.excel.cmd.stamp.expand.work;

import java.util.List;

import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateCellType;
import com.bokesoft.yigo.struct.expand.IExpandWork;
import com.bokesoft.yigo.struct.expand.processor.DimensionItem;

/**
 * 处理excel模板中的表格明细扩展
 * 
 * @author chenbb
 *
 */
public class ExcelTableDetailExpandWork implements IExpandWork<ExcelTemplateField, ExcelTemplateField> {
	
	private ExcelTemplateTable baseExcelTemplateTable;

	public ExcelTableDetailExpandWork(ExcelTemplateTable baseExcelTemplateTable) {
		this.baseExcelTemplateTable = baseExcelTemplateTable;
	}

	@Override
	public void doWork(List<String> fixedFieldKeys,
			List<DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField>> colRootDimensionItems,
			List<DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField>> rowRootDimensionItems) {
		for (DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField> rootDimenItem : colRootDimensionItems) {
			expandTemplateTable(rootDimenItem, baseExcelTemplateTable);
		}
		String targetKey = this.getExpandTargetKey(baseExcelTemplateTable.getKey());
		baseExcelTemplateTable.setTableKey(targetKey);
	}
	
	/**
	 * 扩展处理excel模板表格
	 * @param rootDimenItem
	 * @param templateTable
	 */
	private void expandTemplateTable(DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField> rootDimenItem, ExcelTemplateTable templateTable) {
		// 将扩展列后的字段列序号后移，预留扩展目标字段空间
		ExcelTemplateField sourceField = rootDimenItem.getSourceField();
		int detailRowIndex = sourceField.getRowIndex();
		templateTable.shiftCellIndexAfter(detailRowIndex, sourceField.getColIndex(), rootDimenItem.getLeafCount() - 1);
		createExpandDetailFields(rootDimenItem, templateTable);
		// 移除原始扩展字段，以及维度字段
		//removeBaseExpandField(sourceField, templateTable);
		// 对表模板中的字段按列序号排序
		//sortFields(templateTable);
	}
	
	private void createExpandDetailFields(DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField> rootDimenItem, ExcelTemplateTable templateTable) {
		int inc = 0;
		ExcelTemplateField sourceField = rootDimenItem.getSourceField();
		int detailRowIndex = sourceField.getRowIndex();
		for (DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField> dimenItem : rootDimenItem.getAllLeafs()) {
			String expandTargetFieldKey = dimenItem.getPathKey();
			ExcelTemplateField targetField = ExcelTemplateField.create(expandTargetFieldKey, detailRowIndex, sourceField.getColIndex() + inc, sourceField.getSheetName());
			targetField.setSourceType(ExcelTemplateCellType.Field);
			targetField.setDataType(sourceField.getDataType());
			templateTable.addField(targetField);
			inc ++;
		}
	}
}
