package com.bokesoft.yes.excel.cmd.stamp.expand;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReader;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.common.struct.PairItem;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.expand.AbstractDimensionsCreator;

/**
 * 
 * excel导入时, 根据sheet的表格头数据，生成列扩展树集合
 * @author chenbb
 *
 */
public class SheetDimensionCreator extends AbstractDimensionsCreator<ExcelTemplateField, ExcelTemplateField> {
	
	private ExcelTemplateTable templateTable = null;
	
	private IInputReader sheetReader = null;
	
	public SheetDimensionCreator(ExcelTemplateTable templateTable, IInputReader sheetReader) {
		this.templateTable = templateTable;
		this.sheetReader = sheetReader;
		this.sortFields(this.templateTable);
	}
	
	private void sortFields(ExcelTemplateTable templateTable) {
		Collections.sort(templateTable.getFields(), new Comparator<ExcelTemplateField>() {
			@Override
			public int compare(ExcelTemplateField o1, ExcelTemplateField o2) {
				if (o1.getColIndex() < o2.getColIndex()) {
					return -1;
				} else if (o1.getColIndex() > o2.getColIndex()) {
					return 1;
				}
				return 0;
			}
		});
	}

	/**
	 * 获取维度扩展的最后ColIndex
	 * @param dimensionField
	 * @return
	 */
	private int getLastExpandTargetColIndex(ExcelTemplateField expandSourceField, int dimensionRowIndex) {
		int lastCellNum = sheetReader.getLastCellNum(dimensionRowIndex);
		ExcelTemplateField nextField = templateTable.getNextFieldInSameRow(expandSourceField);
		int nextColIndex = (nextField == null ? lastCellNum : nextField.getColIndex());
		return nextColIndex - 1;
	}
	
	
	@Override
	protected List<IPairItem> getDimensionValues(ExcelTemplateField dimensionField) throws Throwable {
		ArrayList<IPairItem> dimenValueList = new ArrayList<>();
		ExcelTemplateField expandSourceField = templateTable.getExpandSourceField(dimensionField.getKey());
		if (expandSourceField == null) {
			return dimenValueList;
		}
		int dimensionRowIndex = dimensionField.getRowIndex();
		int startTargetColIndex = expandSourceField.getColIndex();
		int lastTargetColIndex = getLastExpandTargetColIndex(expandSourceField, dimensionRowIndex);
		String value = null;
		List<String> valueList = new ArrayList<>();
		for (int colIndex = startTargetColIndex; colIndex <= lastTargetColIndex; colIndex ++) {
			value = TypeConvertor.toString(sheetReader.getValue(dimensionRowIndex, colIndex, null));
			if (!StringUtil.isBlankOrNull(value) && !valueList.contains(value)) {
				valueList.add(value);
			}
		}
		
		for (String v : valueList) {
			dimenValueList.add(new PairItem(dimensionField, v));
		}
		return dimenValueList;
	}

}
