package com.bokesoft.yes.excel.cmd.normal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DataObjectSecondaryType;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class ExportExcelParas {
	private HashMap<String, HashMap<String, ExportComponentInfo>> tableControl = new HashMap<String, HashMap<String, ExportComponentInfo>>();

	private HashMap<String, ArrayList<String>> tableColumn = new HashMap<String, ArrayList<String>>();
	
	private String relationalKey = null;
	
	private String relationalCaption = null;
	
	public ExportExcelParas(DefaultContext context, MetaForm metaForm) {
		MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();

		MetaTable metaTable = null;
		Iterator<MetaTable> itTables = metaDataObject.getTableCollection().iterator();
		while (itTables.hasNext()) {
			metaTable = itTables.next();
			int tableMode = metaTable.getTableMode();
			switch (tableMode) {
			case TableMode.HEAD:
				dealHeadTable(metaForm, metaTable);
				break;
			case TableMode.DETAIL:
				dealDetailTable(metaForm, metaTable);
				break;
			}
		}
		
		MetaTable mainTable = metaDataObject.getMainTable();
		int secondaryType = metaDataObject.getSecondaryType();
		switch (secondaryType) {
		case DataObjectSecondaryType.NORMAL:
			if (mainTable.containsKey(SystemField.NO_SYS_KEY)) {
				relationalKey = SystemField.NO_SYS_KEY;
			} else {
				relationalKey = SystemField.OID_SYS_KEY;
			}
			relationalCaption = mainTable.get(relationalKey).getCaption();
			break;
		case DataObjectSecondaryType.CHAINDICT:
		case DataObjectSecondaryType.DICT:
		case DataObjectSecondaryType.COMPDICT:
			relationalKey = SystemField.CODE_DICT_KEY;
			relationalCaption = mainTable.get(relationalKey).getCaption();
			break;
		}
		
		ArrayList<String> columns = tableColumn.get(mainTable.getKey());
		if (!columns.contains(relationalKey)) {
			columns.add(0, relationalKey);
		}
	}

	private void dealDetailTable(MetaForm metaForm, MetaTable metaTable) {
		String tableKey = metaTable.getKey();

		MetaComponent metaComponent = metaForm.findComponentByTable(tableKey);
		if (metaComponent == null)
			return;
		switch (metaComponent.getControlType()) {
		case ControlType.GRID:
			dealGridDetailTable(metaForm, metaTable, (MetaGrid) metaComponent);
			break;
		case ControlType.LISTVIEW:
			dealListViewDetailTable(metaForm, metaTable, (MetaListView) metaComponent);
			break;
		case ControlType.EDITVIEW:
			dealEditViewDetailTable(metaForm, metaTable, (MetaEditView) metaComponent);
			break;
		default:
			break;
		}
	}
	
	private void dealListViewDetailTable(MetaForm metaForm, MetaTable metaTable, MetaListView metaListView) {
		String tableKey = metaTable.getKey();
		
		// 记录ColumnKey和MetaComponent的关系
		HashMap<String, ExportComponentInfo> map = new HashMap<String, ExportComponentInfo>();
		ArrayList<String> list = new ArrayList<String>();
		
		// 先找到数据行
		MetaListViewColumn listViewColumn = null;
		Iterator<MetaListViewColumn> itListViewColumn = metaListView.getColumnCollection().iterator();
		while (itListViewColumn.hasNext()) {
			listViewColumn = itListViewColumn.next();
			String columnKey = listViewColumn.getDataColumnKey();
			if (columnKey != null && !columnKey.isEmpty()) {
				map.put(columnKey, new ExportComponentInfo(listViewColumn.getCaption(), listViewColumn.getColumnType(), listViewColumn.getProperties()));
				list.add(columnKey);
			}
		}
		
		tableControl.put(tableKey, map);
		tableColumn.put(tableKey, list);
	}

	private void dealEditViewDetailTable(MetaForm metaForm, MetaTable metaTable, MetaEditView metaEditView) {
		String tableKey = metaTable.getKey();
		
		// 记录ColumnKey和MetaComponent的关系
		HashMap<String, ExportComponentInfo> map = new HashMap<String, ExportComponentInfo>();
		ArrayList<String> list = new ArrayList<String>();
		
		// 先找到数据行
		MetaEditViewColumn EditViewColumn = null;
		Iterator<MetaEditViewColumn> itEditViewColumn = metaEditView.getColumnCollection().iterator();
		while (itEditViewColumn.hasNext()) {
			EditViewColumn = itEditViewColumn.next();
			String columnKey = EditViewColumn.getDataColumnKey();
			if (columnKey != null && !columnKey.isEmpty()) {
				map.put(columnKey, new ExportComponentInfo(EditViewColumn.getCaption(), EditViewColumn.getColumnType(), EditViewColumn.getProperties()));
				list.add(columnKey);
			}
		}
		
		tableControl.put(tableKey, map);
		tableColumn.put(tableKey, list);
	}
	
	private void dealGridDetailTable(MetaForm metaForm, MetaTable metaTable, MetaGrid metaGrid) {
		String tableKey = metaTable.getKey();

		// 记录ColumnKey和MetaComponent的关系
		HashMap<String, ExportComponentInfo> map = new HashMap<String, ExportComponentInfo>();
		ArrayList<String> list = new ArrayList<String>();

		// 先找到数据行
		Iterator<MetaGridRow> itRow = metaGrid.getRowCollection().iterator();
		MetaGridRow metaRow = null;
		MetaGridCell metaCell = null;
		while (itRow.hasNext()) {
			metaRow = itRow.next();
			if (metaRow.getRowType() == RowType.Detail) {
				Iterator<MetaGridCell> itCell = metaRow.iterator();
				while (itCell.hasNext()) {
					metaCell = itCell.next();
					String columnKey = metaCell.getColumnKey();
					if (columnKey != null && !columnKey.isEmpty()) {
						map.put(columnKey, new ExportComponentInfo(metaCell.getCaption(), metaCell.getCellType(), metaCell.getProperties()));
						list.add(columnKey);
					}
				}
			}
		}

		tableControl.put(tableKey, map);
		tableColumn.put(tableKey, list);
	}

	public void dealHeadTable(MetaForm metaForm, MetaTable metaTable) {
		String tableKey = metaTable.getKey();
		// 记录ColumnKey和MetaComponent的关系
		HashMap<String, ExportComponentInfo> map = new HashMap<String, ExportComponentInfo>();
		ArrayList<String> list = new ArrayList<String>();
		// 先找到属于这张表的字段
		String columnKey = null;
		MetaComponent metaComponent = null;
		MetaColumn metaColumn = null;
		Iterator<MetaColumn> it = metaTable.iterator();
		while (it.hasNext()) {
			metaColumn = it.next();
			columnKey = metaColumn.getKey();
			metaComponent = metaForm.getComponentByDataBinding(tableKey, columnKey);

			if (metaComponent != null) {
				map.put(columnKey, new ExportComponentInfo(metaComponent.getCaption(), metaComponent.getControlType(), metaComponent.getProperties()));
				list.add(columnKey);
			}
		}
		
		tableControl.put(tableKey, map);
		tableColumn.put(tableKey, list);
	}

	public String getRelationalKey() {
		return relationalKey;
	}

	public String getRelationalCaption() {
		return relationalCaption;
	}
	
	public HashMap<String, ExportComponentInfo> getComponentInfoByTableKey(String tableKey) {
		return tableControl.get(tableKey);
	}
	
	public ArrayList<String> getColumnListByTableKey(String tableKey) {
		return tableColumn.get(tableKey);
	}
}
