package com.bokesoft.yes.excel.cmd.dee;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.describe.GetDescribeService;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class DescribeCmd extends DefaultServiceCmd {

	private String formKey;
	
	public DescribeCmd(){
		formKey = null;
	}
	
	
	public DescribeCmd(String formKey) {
		super();
		this.formKey = formKey;
	}
	

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("FormKey"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		Object result = GetDescribeService.get(context, formKey);
		return result;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new DescribeCmd();
	}

	@Override
	public String getCmd() {
		return "Describe";
	}


	public String getFormKey() {
		return formKey;
	}


	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}

}
