package com.bokesoft.yes.dts.data;

import java.util.List;
import java.util.Map;
import java.util.Set;
import com.bokesoft.yes.dts.types.OperationTypes;
import com.bokesoft.yigo.struct.document.Document;

/**
 * 封装Document和调用数据传输服务需要用到的参数
 * @author lingc
 *
 */
public class DTSData {
	
	/**
	 * 原始文档
	 */
	private Document document;
	
	private String dataObjectKey;
	
	private String formKey;
	
	/** 头表的操作*/
	private OperationTypes operation;
	
	/** 表的key对应表的业务关键字集合*/
	private Map<String, List<String>> primaryMap;
	
	/** insert操作是否需要检查唯一性*/
	private boolean insertCheck;
	
	/** 需要update的行不存在是否抛出异常*/
	private boolean updateCheck;
	
	/** 是否需要删除原本表中没有匹配到的数据*/
	private Set<String> deleteUnknownSet;
	
	/** 是否需要删除原本表中所有的数据*/
//	private final Set<String> deleteAllSet;
	
	/** 需要返回的字段*/
	private List<String> returnFields;
	
	/** 记录每行的操作*/
	private Map<String, List<OperationTypes>> opMap;
	
	/** 是否启动流程 */
	private boolean startInstance;
	
	/** 绑定的流程的Key*/
	private String processKey;
	
	public DTSData(){
		
	}
	
	public DTSData(DTSDataBuilder builder){
		document = builder.getDocument();
		dataObjectKey = builder.getDataObjectKey();
		formKey = builder.getFormKey();
		operation = builder.getOperation();
		primaryMap = builder.getPrimaryMap();
		insertCheck = builder.getInsertCheck();
		updateCheck = builder.getUpdateCheck();
		deleteUnknownSet = builder.getDeleteUnknownSet();
//		deleteAllSet = builder.deleteAllSet;
		returnFields = builder.getReturnFields();
		opMap = builder.getOpMap();
		startInstance = builder.getStartInstance();
		processKey = builder.getProcessKey();
	}
	
	public void setOpMap(Map<String, List<OperationTypes>> val){
		this.opMap = val;
	}
	
	public Map<String, List<OperationTypes>> getOpMap() {
		return opMap;
	}
	
	/**
	 * 获得表的操作
	 * @param tableKey
	 * @return
	 */
	public List<OperationTypes> getTableOp(String tableKey){
		if(opMap == null)
			return null;
		return opMap.get(tableKey);
	}

	public void setDataObjectKey(String val){
		this.dataObjectKey = val;
	}
	
	public String getDataObjectKey() {
		return dataObjectKey;
	}

	
	public void setFormKey(String val){
		this.formKey = val;
	}
	

	public String getFormKey() {
		return formKey;
	}

	public void setDocument(Document val){
		this.document = val;
	}
	
	public Document getDocument() {
		return document;
	}


	public void setOperation(OperationTypes val){
		this.operation = val;
	}
	
	public OperationTypes getOperation() {
		return operation;
	}

	public void setInsertCheck(boolean val){
		this.insertCheck = val;
	}
	
	public boolean isInsertCheck() {
		return insertCheck;
	}

	public void setUpdateCheck(boolean val){
		this.updateCheck = val;
	}
	
	public boolean isUpdateCheck() {
		return updateCheck;
	}

	public void setPrimaryMap(Map<String, List<String>> val){
		this.primaryMap = val;
	}
	
	public Map<String, List<String>> getPrimaryMap() {
		return primaryMap;
	}
	/**
	 * 获取表的业务关键字集合
	 * @param tableKey
	 * @return
	 */
	public List<String> getPrimary(String tableKey) {
		if(primaryMap == null)
			return null;
		return primaryMap.get(tableKey);
	}
	
	public void setReturnFields(List<String> val){
		this.returnFields = val;
	}
	
	public List<String> getReturnFields() {
		return returnFields;
	}


	public void setDeleteUnknownSet(Set<String> val){
		this.deleteUnknownSet = val;
	}
	
	public Set<String> getDeleteUnknownSet() {
		return deleteUnknownSet;
	}

	/**
	 * 某个表是否要删除未匹配数据
	 * @param key
	 * @return
	 */
	public boolean deleteUnknown(String key){
		if(deleteUnknownSet == null)
			return false;
		return deleteUnknownSet.contains(key);
	}


//	public Set<String> getDeleteAllSet() {
//		return deleteAllSet;
//	}

	public void setStartInstance(boolean val){
		this.startInstance = val;
	}
	
	public boolean isStartInstance() {
		return startInstance;
	}

	public void setProcessKey(String val){
		this.processKey = val;
	}
	
	public String getProcessKey() {
		return processKey;
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("数据传输服务\n");
		sb.append("文档:\n"+document);
		sb.append("formKey: "+formKey+"\n");
		sb.append("operation: "+getOperationName(operation)+"\n");
		sb.append("primary columns:\n");
		for(String key: primaryMap.keySet()){
			sb.append(key+"\t");
			List<String> list = primaryMap.get(key);
			if(list!=null){
				for(String columnKey: list){
					sb.append(columnKey+",");
				}
				sb.deleteCharAt(sb.length() - 1);
			}
			sb.append("\n");
		}
		sb.append("update check: "+updateCheck + "\n");
		if(deleteUnknownSet != null){
			sb.append("delete unknown set: ");
			for(String tableKey: deleteUnknownSet){
				sb.append(tableKey+",");
			}
			sb.deleteCharAt(sb.length() - 1);
			sb.append("\n");
		}
		if(returnFields !=null ){
			sb.append("return fields: ");
			for(String returnField: returnFields){
				sb.append(returnField+",");
			}
			sb.deleteCharAt(sb.length() - 1);
			sb.append("\n");
		}
		sb.append("start instance: "+startInstance+"\n");
		sb.append("processKey: "+processKey+"\n");
		return sb.toString();
	}

	private String getOperationName(OperationTypes op){
		String name;
		switch (op) {
		case INSERT:
			name = "inseret";
			break;
		case UPDATE:
			name = "update";
			break;
		case DELETE:
			name = "delete";
			break;
		case I_OR_U:
			name = "insert or update";
			break;
		case DEFAULT:
			name = "default";
			break;
		default:
			name = null;
			break;
		}
		return name;
	}
	
}
