package com.bokesoft.yes.design;

import java.util.HashMap;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.service.GeneralService;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;

public class GridDesignService extends GeneralService<DefaultContext> {
	@Override
	public String getServiceName() {
		return "GridDesign";
	}
	
	@Override
	protected Object[][] getCmdImplTable() {
		
		return new Object[][]{
				{ "QueryGridTemplates", new QueryGridTemplatesCmd() },
				{ "SaveGridTemplate", new SaveGridTemplateCmd() },
				{ "LoadGridTemplate", new LoadGridTemplateCmd() }
		};
	}
	
	@Override
	public Object process(DefaultContext context, String cmd,
			StringHashMap<Object> arguments) throws Throwable {
		return super.process(context, cmd, arguments);
	}

	@Override
	protected IServiceCmd<DefaultContext> getDefaultImpl() {
		// TODO
		return null;
	}

	@SuppressWarnings("unchecked")
	@Override
	public IServiceCmd<DefaultContext> getPrototype(DefaultContext context,
			String cmd) {
		return (IServiceCmd<DefaultContext>)GridDesignService.prototype.get(cmd);
	}
	
	private static HashMap<String, IServiceCmd<?>> prototype = null;
	static {
		GridDesignService.prototype = new HashMap<String, IServiceCmd<?>>();
		GeneralService.initPrototype(GridDesignService.prototype, new GridDesignService());
	}
	
	@Override
	public IServiceProvider<DefaultContext> newInstance() {
		return new GridDesignService();
	}

}
