package com.bokesoft.yes.data.cmd.normal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yes.excel.cmd.normal.IImport;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.def.OperationState;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;

public class ImportData4Bill implements IImport {
	
	/** 表单标识*/
	private String formKey = null;
	/** 上下文环境 */
	private DefaultContext context;
	/** 数据源配置对象 */
	private MetaDataObject metaDataObject;
	
	/** 源Document*/
	private Document document = null;
	/** 记录导入的字段*/
	private HashMap<String, List<String>> importFields = null;

	private byte[] bytes  = null;
	
	public static String DICTSEPARATOR = "#";
	public static String COLUMNSEPARATOR = ";";

	public ImportData4Bill(String formKey, DefaultContext context, MetaDataObject metaDataObject, byte[] bytes , Document document) {
		this.formKey = formKey;
		this.context = context;
		this.bytes = bytes;
		this.metaDataObject = metaDataObject;
		this.document = document;
		
		_init();
	}
	
	// 模板信息和批量导入的保持一致
	private void _init() {
		InputStream is = new ByteArrayInputStream(bytes);
		InputStreamReader isr = new InputStreamReader(is);
		BufferedReader bf = new BufferedReader(isr);
		
		String line = null;
		importFields = new HashMap<String, List<String>>();
		
		try {

			// 记录明细表已导入的行数
			ArrayList<String> fieldList= null;
			String key = null;
			while((line = bf.readLine()) != null){
				line = replaceBlank(line);
				if(!line.endsWith(COLUMNSEPARATOR))
		    		continue;
				line = line.substring(0, line.length() - 1);
				if(line.startsWith("Table:")){
					key = line.split(":")[1];
					fieldList = new ArrayList<String>();
				}else{
					if(fieldList.size() == 0){
						String[] values = line.split(COLUMNSEPARATOR);
						for (int i = 0; i < values.length; i++) {
							fieldList.add(values[i]);
						}
						importFields.put(key, fieldList);
					}
					
				}
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	

	public Object importData() throws Throwable {
		InputStream is = new ByteArrayInputStream(bytes);
		InputStreamReader isr = new InputStreamReader(is);
		BufferedReader bf = new BufferedReader(isr);
		String line = null;
		
		ArrayList<String> tableKeys = new ArrayList<String>();
		HashMap<String, ArrayList<String>> tableMap = new HashMap<String, ArrayList<String>>();
		ArrayList<String> dataList= null;
		String tempKey = null;
		while((line = bf.readLine()) != null){
			line = replaceBlank(line);
			if(!line.endsWith(COLUMNSEPARATOR))
	    		continue;
			line = line.substring(0, line.length() - 1);
		    if(line.startsWith("Table:")){
				tempKey = line.split(":")[1];
				dataList = new ArrayList<String>();
				tableMap.put(tempKey, dataList);
				tableKeys.add(tempKey);
		    }else{
				dataList.add(line);
			}
		}
		
		String tableKey = null; 
		MetaTable metaTable = null;
		for (int i = 0; i < tableKeys.size(); i++) {
			tableKey = tableKeys.get(i);
			metaTable = metaDataObject.getTable(tableKey);

			switch (metaTable.getTableMode()) {
			case TableMode.HEAD:
				fillHeadData(tableMap.get(tableKey), document, tableKey);
				break;
			case TableMode.DETAIL:
				fillDetailData(tableMap.get(tableKey), document, tableKey);
				break;
			}
		}
		return document;
		
		
	}
	
	public static String replaceBlank(String str){
		String dest = "";
		if(str != null){
			Pattern p = Pattern.compile("\\s*|\t|\r|\n");
			Matcher m = p.matcher(str);
			dest = m.replaceAll("");
		}
		
		return dest;
	}
	
	private void fillHeadData(ArrayList<String> dataList, Document document, String tableKey) throws Throwable {
		MetaTable metaTable = metaDataObject.getMetaTable(tableKey);
		DataTable dataTable = document.get(tableKey);
		dataTable.first();
		fillImportField(metaTable, dataTable, dataList, 2, importFields.get(tableKey));
	}
	
	private void fillDetailData(ArrayList<String> dataList, Document document, String tableKey) throws Throwable {
		MetaTable metaTable = metaDataObject.getMetaTable(tableKey);
		DataTable dataTable = document.get(tableKey);
		boolean isEmpty = false;
		
		int rowIndex = 2;
		while (true) {
			DocumentUtil.newRow(metaTable, dataTable);
			isEmpty = fillImportField(metaTable, dataTable, dataList, rowIndex, importFields.get(tableKey));
			if (isEmpty) {
				dataTable.delete();
				break;
			}
			rowIndex++;
		}
	}
	
	// 填充导入的字段,并判断是否空行
	private boolean fillImportField(MetaTable metaTable, DataTable dataTable, ArrayList<String> dataList, int rowIndex, List<String> fields) throws Throwable {
		boolean isEmpty = true;
		for (int colIndex = 0; colIndex < fields.size(); colIndex++) {
			String columnKey = fields.get(colIndex);
			String[] columnKeys = columnKey.split(DICTSEPARATOR);
			
			Object value = getValue(metaTable, dataList ,rowIndex,  colIndex + 1 , columnKey );
			
			if (TypeConvertor.toString(value).isEmpty()) {
				continue;
			} 
			isEmpty = false;
			value = transformValue(metaTable, columnKey, value);
			
			dataTable.setObject(columnKeys[0], value);
		}
		
		return isEmpty;
	}
	
	// 从Excel中获取导入的值，根据字段类型做转换
	private Object transformValue(MetaTable metaTable, String fieldKey, Object value) throws Throwable {
		String[] fields = fieldKey.split(DICTSEPARATOR);
		String columnKey = fields[0];
		if (fields.length > 1) {
			String itemKey = fields[1];
			IDictCacheProxy dictCache = context.getDictCache();
			MetaDataObject dictDataObject = context.getVE().getMetaFactory().getDataObject(itemKey);
			List<MetaColumn> displayColumns = dictDataObject.getDisplayColumns();
			for (MetaColumn metaColumn : displayColumns) {
				Item item = dictCache.locate(itemKey, metaColumn.getKey(), value.toString(), null, null, DictStateMask.All, OperationState.Default);
				if (item != null) {
					value = item.getID();
					break;
				}
			}
		}

		// 根据数DataType转型
		MetaColumn column = metaTable.get(columnKey);
		int dataType = column.getDataType();
		value = TypeConvertor.toJavaType(DBTypeUtil.dataType2JavaDataType(dataType), value);

		return value;
	}
	
	private Object getValue(MetaTable metaTable, ArrayList<String> dataList, int rowIndex, int colIndex, String fieldKey) throws Throwable {

		if(rowIndex >= dataList.size()) 
			return null;
		String dataStr = dataList.get(rowIndex);
		String[] dataArray = dataStr.split(COLUMNSEPARATOR);
		String columnKey = null;
		String[] fields = fieldKey.split(DICTSEPARATOR);
		columnKey = fields[0];
		
		Object value = dataArray[colIndex];
		
		if (value != null && !value.toString().isEmpty()) {
			String sValue = TypeConvertor.toString(value);
			if (fields.length > 1) {
				value = 0;
				String itemKey = fields[1];
				IDictCacheProxy dictCache = context.getDictCache();
				MetaDataObject dictDataObject = context.getVE().getMetaFactory().getDataObject(itemKey);
				if (dictDataObject == null) {
					throw new MetaException(MetaException.NO_DATAOBJECT_DEFINED, 
							SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataObjectDefined), itemKey));
				}				
				List<MetaColumn> displayColumns = dictDataObject.getDisplayColumns();
				for (MetaColumn metaColumn : displayColumns) {
					Item item = dictCache.locate(itemKey, metaColumn.getKey(), sValue, null, null, DictStateMask.All, OperationState.Default);
					if (item != null) {
						value = item.getID();
						break;
					}
				}
			}
		}
		// 根据数DataType转型
		MetaColumn column = metaTable.get(columnKey);
		if( column == null ) {
			throw new MidCoreException(MidCoreException.IMPORT_COLUMN_UNDEFINED,
					MidCoreException.formatMessage(null, MidCoreException.IMPORT_COLUMN_UNDEFINED, columnKey));
		}
		return TypeConvertor.toJavaType(DBTypeUtil.dataType2JavaDataType(column.getDataType()), value);
	}
	
	
}
