/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template;

import com.bokesoft.yes.excel.template.ExcelBorder;
import com.bokesoft.yes.excel.template.ExcelFont;
import com.bokesoft.yes.excel.template.ExcelFormat;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelDisplay;

public class ExcelDisplay {
    private ExcelFont font = null;
    private ExcelFormat format = null;
    private ExcelBorder border = null;
    private int hAlign = 1;
    private int vAlign = 1;
    private String backColor = "";
    private String foreColor = "";
    private boolean wrapText = false;

    private ExcelDisplay() {
    }

    public ExcelDisplay(MetaExcelDisplay metaExcelDisplay) {
        this.hAlign = metaExcelDisplay.getHAlign();
        this.vAlign = metaExcelDisplay.getVAlign();
        this.backColor = metaExcelDisplay.getBackColor();
        this.foreColor = metaExcelDisplay.getForeColor();
        this.wrapText = metaExcelDisplay.isWrapText();
        if (metaExcelDisplay.getFont() != null) {
            this.font = new ExcelFont(metaExcelDisplay.getFont());
        }
        if (metaExcelDisplay.getFormat() != null) {
            this.format = new ExcelFormat(metaExcelDisplay.getFormat());
        }
        if (metaExcelDisplay.getBorder() != null) {
            this.border = new ExcelBorder(metaExcelDisplay.getBorder());
        }
    }

    public void setFont(ExcelFont excelFont) {
        this.font = excelFont;
    }

    public ExcelFont getFont() {
        return this.font;
    }

    public void setFormat(ExcelFormat excelFormat) {
        this.format = excelFormat;
    }

    public ExcelFormat getFormat() {
        return this.format;
    }

    public ExcelBorder getBorder() {
        return this.border;
    }

    public void setBorder(ExcelBorder excelBorder) {
        this.border = excelBorder;
    }

    public int getHAlign() {
        return this.hAlign;
    }

    public int getVAlign() {
        return this.vAlign;
    }

    public String getBackColor() {
        return this.backColor;
    }

    public String getForeColor() {
        return this.foreColor;
    }

    public void setHAlign(int n) {
        this.hAlign = n;
    }

    public void setVAlign(int n) {
        this.vAlign = n;
    }

    public void setBackColor(String string) {
        this.backColor = string;
    }

    public void setForeColor(String string) {
        this.foreColor = string;
    }

    public boolean isWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean bl) {
        this.wrapText = bl;
    }

    public ExcelDisplay clone() {
        ExcelDisplay excelDisplay = new ExcelDisplay();
        excelDisplay.setHAlign(this.hAlign);
        excelDisplay.setVAlign(this.vAlign);
        excelDisplay.setBackColor(this.backColor);
        excelDisplay.setForeColor(this.foreColor);
        excelDisplay.setFont(this.font == null ? null : this.font.clone());
        excelDisplay.setFormat(this.format == null ? null : this.format.clone());
        excelDisplay.setBorder(this.border == null ? null : this.border.clone());
        return excelDisplay;
    }

    public String createStyleKey() {
        return (this.font == null ? "NullFont" : this.font.createStyleKey()) + "#" + (this.border == null ? "NullBorder" : this.border.createStyleKey()) + "#" + this.hAlign + "#" + this.vAlign + "#" + this.backColor + "#" + this.foreColor + "#" + this.wrapText + (this.format == null ? "NullFormat" : this.format.getFieldKeys() + "#" + this.format.getFormatString() + "#" + this.format.getItemKey());
    }
}

