/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.input.doc.in;

import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.expand.SheetDimensionCreator;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutTable;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.IInputRowAction;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReader;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.struct.expand.IExpandTableDefine;
import com.bokesoft.yigo.struct.expand.processor.DimensionItem;
import java.util.Iterator;
import java.util.List;

public class InTable4Expand
implements IInTable {
    private int startRowIndex;
    private int endRowIndex;
    private ExcelTemplateTable templateTable = null;
    private IInputReaderBag workbookReader = null;
    private List<DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField>> dimenRoots = null;
    private int curExpandBaseIndex = 0;
    private int curExpandTargetIndex = 0;
    private DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField> curDimenItem = null;

    public InTable4Expand(ExcelTemplateTable excelTemplateTable, int n, int n2, IInputReaderBag iInputReaderBag) {
        this.templateTable = excelTemplateTable;
        this.startRowIndex = n;
        this.endRowIndex = n2;
        this.workbookReader = iInputReaderBag;
        Object object = this.workbookReader.getSheetReader(excelTemplateTable.getSheetName());
        object = new SheetDimensionCreator(excelTemplateTable, (IInputReader)object);
        try {
            this.dimenRoots = object.createDimensions((IExpandTableDefine)excelTemplateTable);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public ExcelTemplateTable getTemplateTable() {
        return this.templateTable;
    }

    @Override
    public String getKey() {
        return this.templateTable.getTableKey();
    }

    private int getEndRow() {
        if (this.templateTable.isDtlTable()) {
            return this.endRowIndex;
        }
        return this.startRowIndex;
    }

    @Override
    public Object getValue(int n, int n2, ExcelProcessContext excelProcessContext) {
        if (n < this.startRowIndex && n2 == this.curExpandBaseIndex) {
            return this.getDimensionValue(n, n2);
        }
        if (n2 == this.curExpandBaseIndex) {
            n2 = this.curExpandTargetIndex;
        }
        return this.workbookReader.getValue(this.templateTable.getSheetName(), n, n2, excelProcessContext);
    }

    private String getDimensionValue(int n, int n2) {
        DimensionItem dimensionItem = this.curDimenItem;
        ExcelTemplateField excelTemplateField = (ExcelTemplateField)dimensionItem.getDimensionField();
        while (dimensionItem != null && excelTemplateField != null) {
            excelTemplateField = (ExcelTemplateField)dimensionItem.getDimensionField();
            if (excelTemplateField.getRowIndex() == n && excelTemplateField.getColIndex() == n2) {
                return dimensionItem.getData().getCaption();
            }
            dimensionItem = this.curDimenItem.getParent();
        }
        return null;
    }

    @Override
    public void doInputRowAction(OutTable outTable, IInputRowAction iInputRowAction, ExcelProcessContext excelProcessContext) throws Throwable {
        for (int i = this.getStartRowIndex(); i <= this.getEndRow(); ++i) {
            for (DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField> dimensionItem : this.dimenRoots) {
                this.curExpandBaseIndex = ((ExcelTemplateField)dimensionItem.getSourceField()).getColIndex();
                int n = 0;
                Iterator object = dimensionItem.getAllLeafs().iterator();
                while (object.hasNext()) {
                    DimensionItem dimensionItem2;
                    this.curDimenItem = dimensionItem2 = (DimensionItem)object.next();
                    this.curExpandTargetIndex = this.curExpandBaseIndex + n;
                    iInputRowAction.doAction(i, this, outTable, this.templateTable, excelProcessContext);
                    ++n;
                }
            }
        }
    }

    @Override
    public int getStartRowIndex() {
        return this.startRowIndex;
    }

    @Override
    public boolean isEmptySheetRow(String string, int n) {
        return this.workbookReader.isEmptySheetRow(string, n);
    }

    @Override
    public boolean isEmptyTableRow(String string, String string2, int n) {
        return this.workbookReader.isEmptyTableRow(string, string2, n);
    }
}

