package com.bokesoft.yigo.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;

import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.normal.IExport;
import com.bokesoft.yes.excel.cmd.normal.LoadMultiPageDocument;
import com.bokesoft.yes.excel.cmd.stamp.ExportExcelWithStamp;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelFormat;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.def.EExcelTemplateType;
import com.bokesoft.yigo.common.ui.AbstractRuntimeUIConfig;
import com.bokesoft.yigo.meta.exceltemplate.ExcelFormatDataType;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.util.DocumentUtil;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.DocumentType;
import com.bokesoft.yigo.struct.document.FilterMap;

public class StampExcelUtil {

	/**
	 * 印记导出Excel
	 * @param newContext
	 * @param curFormKey
	 * @param document
	 * @param filterMap
	 * @param condParameters
	 * @param templateKey
	 * @param sTemplateType
	 * @param runtimeUIConfig
	 * @param savePath
	 * @param needDownload
	 * @param postExportServiceName
	 * @param exportFileName
	 * @return
	 * @throws Throwable
	 */
	public static FileData exportExcelWithStamp(DefaultContext newContext, String curFormKey, Document document, 
			FilterMap filterMap, ConditionParas condParameters, String templateKey, String sTemplateType,
			AbstractRuntimeUIConfig runtimeUIConfig, String savePath, boolean needDownload,
			String postExportServiceName, String exportFileName) throws Throwable {
		FileData fileData = null;
		EExcelTemplateType type = EExcelTemplateType.valueOf(sTemplateType);
		IMetaFactory metaFactory = newContext.getVE().getMetaFactory();
		try {
			MetaForm metaForm = metaFactory.getMetaForm(curFormKey);
			filterMap.setType(DocumentType.DATAOBJECT);
			// 循环查看是否有分页需要重新载入
			if (DocumentUtil.isPaginationForm(curFormKey, newContext)) {
				LoadMultiPageDocument loadMultiPageDocument = new LoadMultiPageDocument(new DefaultContext(newContext),
						filterMap, condParameters);
				document = loadMultiPageDocument.reloadDocument(metaForm);
			} 
			
			IExport export = new ExportExcelWithStamp(newContext, templateKey, type,
					metaForm.getKey(), document, runtimeUIConfig, postExportServiceName, exportFileName,needDownload);
			fileData = export.exportData();
			if (needDownload) {
				StampExcelUtil.downLoadFileData(fileData, savePath);
			}
			newContext.commit();
		} catch (Throwable e) {
			if (newContext != null) {
				newContext.rollback();
			}
			throw e;
		} finally {
			if (newContext != null) {
				newContext.close();
			}
		}
		return fileData;
	}
	
	/**
	 * 导出excel byte[]
	 * @param newContext
	 * @param curFormKey
	 * @param document
	 * @param filterMap
	 * @param condParameters
	 * @param templateKey
	 * @param sTemplateType
	 * @return
	 * @throws Throwable
	 */
	public static byte[] exportExcelBytesWithStamp(DefaultContext newContext, String curFormKey, Document document, 
			FilterMap filterMap, ConditionParas condParameters, String templateKey, String sTemplateType) throws Throwable {
		byte[] bytes = null;
		EExcelTemplateType type = EExcelTemplateType.valueOf(sTemplateType);
		IMetaFactory metaFactory = newContext.getVE().getMetaFactory();
		try {
			MetaForm metaForm = metaFactory.getMetaForm(curFormKey);
			filterMap.setType(DocumentType.DATAOBJECT);
			// 循环查看是否有分页需要重新载入
			if (DocumentUtil.isPaginationForm(curFormKey, newContext)) {
				LoadMultiPageDocument loadMultiPageDocument = new LoadMultiPageDocument(new DefaultContext(newContext),
						filterMap, condParameters);
				document = loadMultiPageDocument.reloadDocument(metaForm);
			} 
			
			ExportExcelWithStamp export = new ExportExcelWithStamp(newContext, templateKey, type,
					metaForm.getKey(), document, null, "", "",true);
			bytes = export.exportToBytes();
			newContext.commit();
		} catch (Throwable e) {
			if (newContext != null) {
				newContext.rollback();
			}
			throw e;
		} finally {
			if (newContext != null) {
				newContext.close();
			}
		}
		return bytes;
	}
	
	/**
	 * 获取excel数据格式
	 * @param excelCell
	 * @param workbook
	 * @return
	 */
	public static short getExcelDataFormatType(String sFormat, Workbook workbook) {
		short formatType = -1;
		if (!StringUtil.isBlankOrNull(sFormat)) {
			DataFormat dataFormat = workbook.createDataFormat();
			formatType = dataFormat.getFormat(sFormat);
		}
		return formatType;
	}
	
	/**
	 * 判断单元格是否为数值格式
	 * @param excelCell
	 * @return
	 */
	public static boolean isNumericCell(int excelFormatDataType) {
		return excelFormatDataType == ExcelFormatDataType.Money ||
				excelFormatDataType == ExcelFormatDataType.Number;
	}
	
	/**
	 * 获取excel数据格式
	 * @param excelCell
	 * @param workbook
	 * @return
	 */
	public static short getExcelCellStyle(ExcelCell excelCell, Workbook workbook) {
		short formatType = -1;
		if (excelCell.getDisplay() == null || excelCell.getDisplay().getFormat() == null) {
			return formatType;
		}
		ExcelFormat format = excelCell.getDisplay().getFormat();
		return StampExcelUtil.getExcelDataFormatType(format.getFormatString(), workbook);
	}
	
	/**
	 * 判断单元格是否为数值格式
	 * @param excelCell
	 * @return
	 */
	public static boolean isNumericCell(ExcelCell excelCell) {
		if (excelCell.getDisplay() == null 
				|| excelCell.getDisplay().getFormat() == null) {
			return false;
		}
		ExcelFormat format = excelCell.getDisplay().getFormat();
		return StampExcelUtil.isNumericCell(format.getDataType());
	}
	
	
	/**
	 * 按模板下载文件,直接通过流生成excel文件
	 * 
	 * @param fileDate
	 * @param savePath
	 * @return
	 * @throws Exception
	 */
	public static boolean downLoadFileData(FileData fileDate, String savePath) throws Exception {
		File saveFile = new File(savePath);
		
		if (!saveFile.exists()) {
			saveFile.createNewFile();
		}
		
		BufferedInputStream bis = null;
		BufferedOutputStream bos = null;
		FileOutputStream fos = null;

		try{
			byte[] b = fileDate.getData();
			ByteArrayInputStream inputStream = new ByteArrayInputStream(b);
		    bis = new BufferedInputStream(inputStream);
			fos = new FileOutputStream(saveFile);
			bos = new BufferedOutputStream(fos);
			byte[] buffer = new byte[1024];
			int len = bis.read(buffer);
			while(len != -1){
				bos.write(buffer,0,len);
				len = bis.read(buffer);
			}
			bos.flush();
			return true;
		}finally{
			if( bis != null ) {
				bis.close();
			}
			if (fos != null) {
				fos.close();
			}
			if (bos != null) {
				bos.close();
			}
		}
	}
	
	// 从Excel中获取导入的值，根据字段类型做转换
/*	public static Object transformDictValue(MetaTable metaTable, Object value, String columnKey, String itemKey, IDictCacheProxy dictCache, IMetaFactory metaFactory) throws Throwable {
		// 根据数DataType转型
		MetaColumn column = metaTable.get(columnKey);
		if( column == null ) {
			throw new MidCoreException(MidCoreException.IMPORT_COLUMN_UNDEFINED,
					MidCoreException.formatMessage(null, MidCoreException.IMPORT_COLUMN_UNDEFINED, columnKey));
		}
		if (value != null && !value.toString().isEmpty()) {
			String sValue = TypeConvertor.toString(value);
			value = 0;
			MetaDataObject dictDataObject = metaFactory.getDataObject(itemKey);
			if (dictDataObject == null) {
				throw new MetaException(MetaException.NO_DATAOBJECT_DEFINED, 
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataObjectDefined), itemKey));
			}				
			List<MetaColumn> displayColumns = dictDataObject.getDisplayColumns();
			if(sValue.contains(",") && column.getDataType() == DataType.STRING){
				List<Item> dictRowCount = dictCache.getAllItems(itemKey,null, 0);
				String[] strArray = sValue.split(",");
				//如果导入模板数据个数和数据库字典数据个数相同则显示全选
				if (dictRowCount.size() == strArray.length){
					value = 0;
				}else{
					value = transformMultiDictValue(strArray, displayColumns, itemKey, dictCache);
				}
			} else {
				value = transformSingleDictValue(sValue, displayColumns, itemKey, dictCache);
			}
		}
		return TypeConvertor.toJavaType(DBTypeUtil.dataType2JavaDataType(column.getDataType()), value);
	}
	*/
	/**
	 * 获取多选字典的实际存储值
	 * @param arrValue
	 * @param displayColumns
	 * @param itemKey
	 * @param dictCache
	 * @return
	 * @throws Throwable
	 */
/*	private static Object transformMultiDictValue(String[] arrValue, List<MetaColumn> displayColumns, String itemKey, IDictCacheProxy dictCache) throws Throwable {
		String ids = "";
		for (int i=0; i<arrValue.length; i++) {
			Object tmpValue = transformSingleDictValue(arrValue[i], displayColumns, itemKey, dictCache);
			if (i==0) {
				ids += tmpValue;
			} else {
				ids += "," + tmpValue;
			}
		}
		return ids;
	}
	
	private static Object transformSingleDictValue(String value, List<MetaColumn> displayColumns, String itemKey, IDictCacheProxy dictCache) throws Throwable {
		Item item = null;
		for (MetaColumn displayColumn : displayColumns) {
			//字典导入的Code全部转化为大写
			if ("Code".equals(displayColumn.getKey())) {
				value = (value != null ? value.toUpperCase() : value);
			}
			item = dictCache.locate(itemKey, displayColumn.getKey(), value, null, null, DictStateMask.All);
			if (item != null) {
				break;
			}
		}
		return item == null ? -1 : item.getID();
	}*/
}