package com.bokesoft.yes.excel.template;

import java.util.ArrayList;
import java.util.Iterator;

import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelSheet;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.parser.IEval;
import com.bokesoft.yigo.struct.document.Document;

/**
 * 通过模板和数据集，构造一个虚拟的workbook
 * 计算扩展列等属性 
 *
 */
public class ExcelWorkbook {
	private ArrayList<ExcelSheet> excelSheets = null; 

	public ExcelWorkbook(MetaDataObject metaDataObject, MetaExcelWorkbook metaWorkbook, IEval parser) {
		this.excelSheets = new ArrayList<ExcelSheet>();
		MetaExcelSheet metaExcelSheet = null;
		Iterator<MetaExcelSheet> itExcelSheet = metaWorkbook.iterator();
		while(itExcelSheet.hasNext()) {
			metaExcelSheet = itExcelSheet.next();
			excelSheets.add(new ExcelSheet(metaDataObject, metaExcelSheet, parser, metaWorkbook.isNeedResetCellIndex()));
		}
	}

	public void calcExpandColumn(IEval parser, Document exportDocument, MetaDataObject metaDataObject) throws Throwable {
		ExcelSheet excelSheet = null;
		Iterator<ExcelSheet> itExcelSheet = excelSheets.iterator();
		while(itExcelSheet.hasNext()) {
			excelSheet = itExcelSheet.next();
			excelSheet.calcExpand(parser, exportDocument, metaDataObject);
		}
	}

	public Iterator<ExcelSheet> iterator() {
		return excelSheets.iterator();
	}
}
