package com.bokesoft.yes.excel.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateRowType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRow;
import com.bokesoft.yigo.parser.IEval;

public class ExcelRow {
	/** 行高 */
	private int height = 0;
	/** 行类型 */
	private int type = -1;
	/** 行号 */
	private int rowIndex = -1;
	/** 分组字段*/
	private String groupDefination = "";
	/** 分组级别*/
	private int groupLevel = 0;
	/** 分组行位置*/
	private String groupPosition = "";
	/** 头部分组行的个数*/
	private int groupHeadRowCount = 0;
	/** 尾部分组行的个数*/
	private int groupTailRowCount = 0;

	/** 类型为明细时 对用的数据源标志 */
	private String tableKey = "";

	private ArrayList<ExcelCell> excelCells = null;

	/** 通过Excel中的列号和单元格联系起来 */
	private LinkedHashMap<Integer, ExcelCell> excelCellMap = null;
	
	private IEval parser = null;
	
	public ExcelRow(MetaExcelRow metaExcelRow, IEval parser, boolean needResetCellIndex) {
		rowIndex = metaExcelRow.getRowIndex();
		type = metaExcelRow.getType();
		height = metaExcelRow.getHeight();
		tableKey = metaExcelRow.getTableKey();
		groupLevel = metaExcelRow.getGroupLevel();
		groupPosition = metaExcelRow.getGroupPosition();
		groupHeadRowCount = metaExcelRow.getGroupHeadRowCount();
		groupTailRowCount = metaExcelRow.getGroupTailRowCount();
		groupDefination = metaExcelRow.getGroupDefination();
		this.parser = parser;

		MetaExcelCell metaExcelCell = null;
		ExcelCell excelCell = null;
		excelCells = new ArrayList<ExcelCell>();
		excelCellMap = new LinkedHashMap<Integer, ExcelCell>();
		Iterator<MetaExcelCell> itExcellCell = metaExcelRow.iterator();
		while (itExcellCell.hasNext()) {
			metaExcelCell = itExcellCell.next();
			excelCell = new ExcelCell(metaExcelCell, rowIndex);
			addCell(excelCell);
		}
		
		resetExportCells(needResetCellIndex);
	}
	
	public int getHeight() {
		return height;
	}

	public int getType() {
		return type;
	}

	public int getRowIndex() {
		return rowIndex;
	}

	public String getTableKey() {
		return tableKey;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public void setType(int type) {
		this.type = type;
	}

	public void setRowIndex(int rowIndex) {
		this.rowIndex = rowIndex;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	public void setGroupLevel(int groupLevel) {
		this.groupLevel = groupLevel;
	}
	
	public int getGroupLevel() {
		return groupLevel;
	}
	
	public void setGroupPosition(String groupPosition) {
		this.groupPosition = groupPosition;
	}
	
	public String getGroupPosition() {
		return groupPosition;
	}
	
	public void setGroupHeadRowCount(int groupHeadRowCount) {
		this.groupHeadRowCount = groupHeadRowCount;
	}
	
	public int getGroupHeadRowCount() {
		return groupHeadRowCount;
	}
	
	public void setGroupTailRowCount(int groupTailRowCount) {
		this.groupTailRowCount = groupTailRowCount;
	}
	
	public int getGroupTailRowCount() {
		return groupTailRowCount;
	}
	
	public void setGroupDefination(String groupDefination) {
		this.groupDefination = groupDefination;
	}
	
	public String getGroupDefination() {
		return groupDefination;
	}

	public boolean hasExpandColumn() {
		ExcelCell excelCell = null;
		Iterator<ExcelCell> itExcelCell = excelCells.iterator();
		while (itExcelCell.hasNext()) {
			excelCell = itExcelCell.next();
			if (excelCell.isColumnExpand()) {
				return true;
			}
		}

		return false;
	}

	public int getCellCount() {
		return excelCells.size();
	}

	// 按照模板列表顺序获取单元格
	public ExcelCell getCell(int cellIndex) {
		return excelCells.get(cellIndex);
	}

	// 按照单元格列号获取单元格
	public ExcelCell getCellByIndexInExcel(int cellIndex) {
		return excelCellMap.get(cellIndex);
	}

	public void replace(int cellIndex, int count, LinkedList<ExcelCell> cells, int childCount) {
		// 将要被替换的单元格列出来
		ArrayList<ExcelCell> replaceCell = new ArrayList<ExcelCell>();
		int startIndex = excelCells.indexOf(getCellByIndexInExcel(cellIndex));
		ExcelCell excelCell = null;
		int maxCellIndex = -1;
		for (int i = 0; i < count; i++) {
			excelCell = getCellByIndexInExcel(cellIndex + i);
			if (excelCell != null) {
				replaceCell.add(excelCell);
				maxCellIndex = cellIndex + i; 
			}
		}

		// 移除要替换的单元格
		for (ExcelCell cell : replaceCell) {
			excelCells.remove(cell);
		}
		
		// 重新编写cellIndex并添加进map中
		int offset = childCount - count;
		for (ExcelCell cell : excelCells) {
			int index = cell.getCellIndex();
			if (index > maxCellIndex) {
				cell.setCellIndex(index + offset);
			}
		}
		
		// 把要替换的加进来
		for (ExcelCell cell : cells) {
			if (cell != null && cell.need) {
				cell.setCellIndex(cellIndex);
				excelCells.add(startIndex, cell);
				++startIndex;
			}
			cellIndex++;
		}
		
		// 重新记录序号和单元格的关系
		excelCellMap.clear();
		for (ExcelCell cell : excelCells) {
			excelCellMap.put(cell.getCellIndex(), cell);
		}
	}

	public Iterator<ExcelCell> iterator() {
		return excelCells.iterator();
	}
	
	private void addCell(ExcelCell cell) {
		excelCells.add(cell);
		excelCellMap.put(cell.getCellIndex(), cell);
	}
	
	/**
	 * 重置单元格位置 , 明细中部分
	 * @param cells
	 */
	public void resetExportCells(boolean needResetCellIndex) {
		// 明细相关行才有可能需要重新设置单元格序号
		boolean canResetCellIndex = true;
		if (type == -1 || type == ExcelTemplateRowType.Head 
				|| type == ExcelTemplateRowType.Fix) {
			canResetCellIndex = false;
		}
		int curIndex = 1;
		if (excelCells.size()  > 0) {
			curIndex = excelCells.get(0).getCellIndex();
		}
		
		excelCellMap.clear();
		for (ExcelCell cell : excelCells) {
			int cellIndex = (canResetCellIndex && needResetCellIndex) ? curIndex : cell.getCellIndex();
			boolean bIgnoreExport = isIgnoreExportCell(cell);
			if (!bIgnoreExport) {
				cell.setCellIndex(cellIndex);
				excelCellMap.put(cellIndex, cell);
				curIndex += cell.getMergedColumnSpan();
			}
		}
		
		excelCells.clear();
		for (Map.Entry<Integer, ExcelCell> entry : excelCellMap.entrySet()) {
			excelCells.add(entry.getValue());
		}
	}
	
	/**
	 * 单元格是否忽略导出
	 * 
	 * @param cell
	 * @return
	 */
	private boolean isIgnoreExportCell(ExcelCell cell) {
		boolean bIgnoreExport = false;
		if (parser == null) {
			return bIgnoreExport;
		}
		try {
			bIgnoreExport = StringUtil.isBlankOrNull(cell.getIgnoreExport()) ? false : TypeConvertor.toBoolean(parser.eval(ScriptType.Formula, cell.getIgnoreExport()));
		} catch (Throwable e) {
			e.printStackTrace();
		}
		return bIgnoreExport;
	}
}
