package com.bokesoft.yes.excel.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelSheet;

public class ExcelColumnExpandCellList implements IExcelColumnCellObject {
	private ExcelCell cell = null;

	/** 
	 * 记录下属单元格和自身的扩展单元格
	 */
	private ArrayList<ExcelCell> excelCellArray = new ArrayList<ExcelCell>();
	private HashMap<Integer, ExcelCell> excelCellMap = new HashMap<Integer, ExcelCell>();

	public void setCell(ExcelCell cell) {
		this.cell = cell;
	}

	public ExcelCell getCell() {
		return cell ;
	}

	public void add(ExcelCell obj) {
		excelCellArray.add(obj);
		if (obj != null) {
			excelCellMap.put(obj.getRowIndex(), obj);
		}
	}
	
	public void addAll(List<ExcelCell> tmpList){
		ExcelCell excelCell = null;
		for (int i = 0; i < tmpList.size(); ++i) {
			excelCell = tmpList.get(i);
			excelCellArray.add(excelCell);
			excelCellMap.put(excelCell.getRowIndex(), excelCell);
		}
	}
	
	@Override
	public int getObjectType() {
		return IExcelColumnCellObject.ExpandCellList;
	}
	
	public IExcelColumnCellObject clone() {
		ExcelColumnExpandCellList newList = new ExcelColumnExpandCellList();
		
		newList.setCell(cell);
		Iterator<ExcelCell> it = excelCellArray.iterator();
		ExcelCell excelCell = null;
		while(it.hasNext()) {
			excelCell = it.next();
			if (excelCell == null) {
				newList.add(null);
			} else {
				newList.add(excelCell.clone());
			}
		}
		
		return newList;
	}

	@Override
	public void traversalCell(ColumnExpandItem columnExpandItem,
			IExcelCellProcess process) {
		Iterator<ExcelCell> it = excelCellArray.iterator();
		while(it.hasNext()) {
			process.process(columnExpandItem, it.next());
		}
	}

	@Override
	public void getLeafCells(LinkedList<ExcelCell> cells, int row) {
		cells.add(excelCellMap.get(row));
	}

	@Override
	public void processMerge(ExcelSheet excelSheet) {
		
	}
}
