package com.bokesoft.yes.excel.template;

import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumnExpand;

public class ExcelColumnExpand {
	/** 扩展类型 */
	private int expandType = -1;
	/** 扩展来源类型 */
	private int sourceType = -1;
	/** 列标识 */
	private String columnKey = "";
	/** 内容*/
	private String content = null;
	
	public ExcelColumnExpand() {
		
	}
	
	public ExcelColumnExpand(MetaExcelColumnExpand metaColumnExpand) {
		expandType = metaColumnExpand.getExpandType();
		sourceType = metaColumnExpand.getSourceType();
		columnKey = metaColumnExpand.getColumnKey();
		content = metaColumnExpand.getContent();
	}

	public int getExpandType() {
		return expandType;
	}

	public int getSourceType() {
		return sourceType;
	}

	public String getColumnKey() {
		return columnKey;
	}

	public String getContent() {
		return content;
	}

	public void setExpandType(int expandType) {
		this.expandType = expandType;
	}

	public void setSourceType(int sourceType) {
		this.sourceType = sourceType;
	}

	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}

	public void setContent(String content) {
		this.content = content;
	}
	
	public ExcelColumnExpand clone() {
		ExcelColumnExpand expand = new ExcelColumnExpand();
		expand.setColumnKey(columnKey);
		expand.setContent(content);
		expand.setExpandType(expandType);
		expand.setSourceType(sourceType);
		
		return expand;
	}
}
