package com.bokesoft.yes.excel.cmd.stamp.output.strategy;

import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputRowProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputSheetProcess;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateColumn;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.constants.ExcelTemplateConstants;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.excel.template.util.ExcelUtil;

/**
 * 单张导出输出策略
 * 
 * @author chenbb
 *
 */
public class SingleOutputStrategy extends BaseOutputStrategy {
	
	public SingleOutputStrategy(Workbook workbook, StampExcelStyleFactory styleFactory, ExcelTemplate excelSheetTemplate) {
		super(workbook, styleFactory, excelSheetTemplate);
	}

	@Override
	public void preOutputSheet(OutputSheetProcess exportSheetProcess) {
		super.preOutputSheet(exportSheetProcess);
		for (ExcelTemplateColumn column : curSheetTemplate.getColumns()) {
			curSheet.setColumnWidth(column.getIndex(), column.getWidth() * 256 / 7 + 500);
		}
	};
	
	@Override
	public void insertRow(int rowIndex, OutputRowProcess exportRowProcess) {
		ExcelTemplateTable templateTable = exportRowProcess.getTemplateTable();
		int startRowIndex = templateTable.getStartDtlRowIndex();
		int sheetRowIndex = startRowIndex + rowIndex + ExcelTemplateConstants.ROW_STEP_NEXT;
		super.insertRow(sheetRowIndex, exportRowProcess);
		Row row = ExcelUtil.getRow(curSheet, sheetRowIndex);
		int rowHeight = exportRowProcess.getTemplateTable().getRowHeight();
		if (rowHeight >= 0) {
			row.setHeightInPoints(rowHeight);
		}
	}
	
	@Override
	public void outputCell(Object value, int rowIndex, int colIndex, ExcelTemplateField field, boolean isDtl) {
		rowIndex += field.getRowIndex() + (isDtl ? ExcelTemplateConstants.ROW_STEP_NEXT : 0);
		setCellValue(value, rowIndex, colIndex, field);
	}

	@Override
	public void postOutputExcel(ExcelTemplate templateExcel) {

	};
	
}
