package com.bokesoft.yes.excel.cmd.stamp.input.process.action;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;

import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutRow;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutTable;
import com.bokesoft.yes.excel.template.ExcelListItem;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateFieldFormat;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.def.OperationState;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.exceltemplate.ExcelFormatDataType;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.dict.Item;

public class InputRowAction implements IInputRowAction {

	@Override
	public void doAction(int row, IInTable inTable, OutTable outTable, ExcelTemplateTable templateTable, ExcelProcessContext context) throws Throwable {
		if (outTable == null) return;
		
		if (templateTable.isDtlTable() && inTable.isEmptySheetRow(templateTable.getSheetName(), row)) {
			return;
		}
		OutRow outRow = outTable.addRow();
		for (ExcelTemplateField templateField : templateTable.getFields()) {
			if (!templateField.isIgnore4Import()) {
				if (context != null ) context.setCurTemplateField(templateField);
				Object value = inTable.getValue(templateTable.isDtlTable() && !templateField.isDimensionField() ? row : templateField.getRowIndex(), templateField.getColIndex(), context);
				value = transValue(value, templateField, context);
				outRow.setValue(templateField.getDefine(), value); 
			}
		}
		if (context != null ) context.setCurTemplateField(null);
	}
	
	
	private Object transValue(Object value, ExcelTemplateField templateField, ExcelProcessContext processContext) throws Throwable {
		ExcelTemplateFieldFormat format = templateField.getFormat();
		MetaDataObject metaDataObject = processContext.getMetaDataObject();
		MetaTable metaTable = metaDataObject.getTable(templateField.getTableKey());
		if (metaTable == null) return value;

		MetaColumn metaColumn = metaTable.get(templateField.getDefine());
		if (metaColumn == null) return value;
		
		int dataType = templateField.getFormat().getDataType();
		switch (dataType) {
		case ExcelFormatDataType.List:
			return getListValue(value, format.getListItems(), metaColumn);
		case ExcelFormatDataType.Dict:
			String sValue = TypeConvertor.toString(value);
			if (!sValue.contains(",")) {
				return getSingleDictValue(value, getDictShowFieldKey(format.getFieldKeys()), format.getItemKey(), processContext.getContext());
			} else {
				return getMultiDictValue(value, getDictShowFieldKey(format.getFieldKeys()), format.getItemKey(), processContext.getContext());
			}
		case ExcelFormatDataType.Money:
		case ExcelFormatDataType.Number:
			return getFormatValue(value, format.getFormatString());
		case ExcelFormatDataType.Image:
		case ExcelFormatDataType.ImageList:
			return value;
		}
		return TypeConvertor.toJavaType(DBTypeUtil.dataType2JavaDataType(metaColumn.getDataType()), value);
	}
	
	private Object getFormatValue(Object value, String formatString) throws ParseException {
		if (StringUtil.isBlankOrNull(formatString)) return value;
		if (StringUtil.isBlankOrNull(value)) return null;
		DecimalFormat df = new DecimalFormat(formatString);
		df.setParseBigDecimal(true);
		return (BigDecimal) df.parse(value.toString());
	}
	
	private Object getListValue(Object value, List<ExcelListItem> listItems, MetaColumn metaColumn) {
		for (ExcelListItem item : listItems) {
			if (TypeConvertor.toString(item.getText()).equals(TypeConvertor.toString(value))) {
				value = item.getValue();
			}
		}
		return TypeConvertor.toJavaType(DBTypeUtil.dataType2JavaDataType(metaColumn.getDataType()), value);
	}
	
	private String getDictShowFieldKey(String fieldKeys) {
		String dictShowFieldKey = fieldKeys;
		if (StringUtil.instr(fieldKeys, ",", "")) {
			dictShowFieldKey = fieldKeys.substring(0, fieldKeys.indexOf(","));
		}
		return dictShowFieldKey;
	}
	
	// 从Excel中获取导入的值，根据字段类型做转换
	private Long getSingleDictValue(Object value, String dictShowFieldKey, String itemKey, DefaultContext context) throws Throwable {
		String sValue = TypeConvertor.toString(value);

		//字典导入的Code全部转化为大写
		if ("Code".equalsIgnoreCase(dictShowFieldKey)) {
			sValue = sValue.toUpperCase();
		}
		
		if (!StringUtil.isBlankOrNull(sValue)) {
			IDictCacheProxy dictCache = context.getDictCache();		
			Item item = dictCache.locate(itemKey, dictShowFieldKey, sValue, null, null, DictStateMask.All, OperationState.Default);
			if (item != null) {
				return item.getID();
			}
		}
		return -1L;
	}
	
	/**
	 * 多选字典字段值导入
	 * @param value
	 * @param dictShowFieldKey
	 * @param itemKey
	 * @param context
	 * @return
	 * @throws Throwable
	 */
	private String getMultiDictValue(Object value, String dictShowFieldKey, String itemKey, DefaultContext context) throws Throwable {
		String sValue = TypeConvertor.toString(value);
		//字典导入的Code全部转化为大写
		if (dictShowFieldKey.equals("Code")){
			value = value.toString().toUpperCase();
		}
		if (!StringUtil.isBlankOrNull(sValue)) {
			IDictCacheProxy dictCache = context.getDictCache();		
			if (sValue.contains(",")) {
				List<Item> dictRowCount = dictCache.getAllItems(itemKey, null, 0, 0);
				String[] strArray = sValue.split(",");
				//如果导入模板数据个数和数据库字典数据个数相同则显示全选
				if (dictRowCount.size() == strArray.length){
					return "0";
				} else {
					String tempValue = "";
					for(int i=0; i<strArray.length; i++){
						Item item = dictCache.locate(itemKey, dictShowFieldKey, strArray[i], null, null, DictStateMask.All, OperationState.Default);
						if (item == null) {
							value = -1L;
						} else {
							value = item.getID();
							if (i != 0){
								tempValue = tempValue + "," + value.toString();
							} else {
								tempValue = value.toString();
							}
						}
					}
					return tempValue;
				}
			}
		}
		return "";
	}

}
