package com.bokesoft.yes.excel.cmd.stamp.expand;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.common.struct.PairItem;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateColumnExpandSourceType;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateColumnExpandType;
import com.bokesoft.yigo.mid.base.BaseContext;
import com.bokesoft.yigo.parser.IEval;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.struct.expand.AbstractDimensionsCreator;

/**
 * 生成excel模板的扩展维度项
 * 
 * @author chenbb
 *
 */
public class TemplateDimensionsCreator extends AbstractDimensionsCreator<ExcelTemplateField, ExcelTemplateField> {
	
	private IEval<BaseContext> expEval = null;
	
	private IDictCacheProxy dictCacheProxy = null;
	
	private DataTable baseDataTable = null;
	
	public TemplateDimensionsCreator(DataTable baseDataTable, IEval<BaseContext> expEval, IDictCacheProxy dictCacheProxy) {
		this.baseDataTable = baseDataTable;
		this.expEval = expEval;
		this.dictCacheProxy = dictCacheProxy;
	}
	
	@Override
	protected List<IPairItem> getDimensionValues(ExcelTemplateField dimensionField) throws Throwable {
		List<IPairItem> items = null;
		if (dimensionField.getExpandType() == ExcelTemplateColumnExpandType.Data) {
			switch (dimensionField.getExpandSourceType()) {
			case ExcelTemplateColumnExpandSourceType.Custom:
				if (expEval != null) {
					Object result = expEval.eval(ScriptType.Formula, dimensionField.getExpandContent(), null, null);
					if (result instanceof String) {
						items = parseToListItems((String) result);
					} else if (result instanceof DataTable)  {
						items = parseToListItems((DataTable) result);
					}
				}
				break;
			case ExcelTemplateColumnExpandSourceType.Data:
				items = parseToItems(dimensionField.getKey(), dimensionField.getDataType(), dimensionField.getItemKey(), baseDataTable);
				break;
			}
		}
		return items;
	}
	
	private List<IPairItem> parseToItems(String columnKey, int dataType, String itemKey, DataTable table) throws Throwable {
		LinkedHashSet<Object> set = new LinkedHashSet<Object>();
		table.beforeFirst();
		while (table.next()) {
			Object value = table.getObject(columnKey);
			set.add(value);
		}
		
		Object value = null;
		Iterator<Object> it = set.iterator();
		ArrayList<IPairItem> items = new ArrayList<>();	
		while (it.hasNext()) {
			value = it.next(); 
			if (value == null || (dataType == DataType.INT && TypeConvertor.toInteger(value) == 0)) {
				continue;
			}
			// 字典类型,作值转换
			String caption = value.toString();
			if( itemKey != null && !itemKey.isEmpty() && dictCacheProxy != null) {
				Item item = dictCacheProxy.getItem(itemKey, TypeConvertor.toLong(value), DictStateMask.All);
				caption = item.getCaption();
			}
			items.add(new PairItem(value, caption));
		}
		return items;
	}
}
