package com.bokesoft.yes.excel.cmd.stamp.dependency.provider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.bokesoft.yes.excel.utils.ImportDictionaryHander;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;

public class ImportExpFieldItemProvider extends BaseExpFieldItemProvider {

	public ImportExpFieldItemProvider(MetaDataObject metaDataObject, HashMap<String, List<String>> importFields) {
		super(metaDataObject);
		filterByImportFields(importFields);
	}
	
	/**
	 * 将需要导入的字段从默认值计算列表中移除
	 * 
	 * @param importFields
	 */
	private void filterByImportFields(HashMap<String, List<String>> importFields) {
		for (Map.Entry<String,  List<String>> entry : importFields.entrySet()) {
			for (String fieldKey : entry.getValue()) {
				String[] fields = fieldKey.split(ImportDictionaryHander.SEPARATOR);
				remove(fields[0], entry.getKey());
			}
		}
	}
}
