package com.bokesoft.yes.excel.cmd.stamp.dependency.provider;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.dependency.ExpFieldItem;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;

public class BaseExpFieldItemProvider implements IExpFieldItemProvider {
	
	private List<ExpFieldItem> baseItems = null;
	
	public BaseExpFieldItemProvider(MetaDataObject metaDataObject) {
		this.baseItems = new ArrayList<>();
		prepareExpFieldItems(metaDataObject);
	}
	
	private void prepareExpFieldItems(MetaDataObject metaDataObject) {
		ExpFieldItem item = null;
		for (MetaTable metaTable : metaDataObject.getTableCollection()) {
			for (MetaColumn metaColumn : metaTable) {
				String formula = metaColumn.getDefaultFormulaValue();
				if (!StringUtil.isBlankOrNull(formula)) {
					item = ExpFieldItem.create(metaColumn.getKey(), metaTable.getKey(), formula, metaTable.isHead());
					this.baseItems.add(item);
				}
			}
		}
	}
	
	protected void remove(String fieldKey, String tableKey) {
		ExpFieldItem tmpItem = null;
		for (ExpFieldItem item : baseItems) {
			if (fieldKey.equalsIgnoreCase(item.getFieldKey()) 
					&& tableKey.equalsIgnoreCase(item.getTableKey())) {
				tmpItem = item;
				break;
			}
		}
		baseItems.remove(tmpItem);
	}

	@Override
	public ExpFieldItem getExpFieldItem(String key) {
		List<ExpFieldItem> tmpItemList = new ArrayList<>();
		for (ExpFieldItem item : baseItems) {
			if (key.equalsIgnoreCase(item.getKey())) {
				return item;
			}
			
			if (key.equalsIgnoreCase(item.getFieldKey())) {
				tmpItemList.add(item);
			}
		}
		
		if (tmpItemList.size() > 0) {
			return tmpItemList.get(0);
		}
		return null;
	}

	@Override
	public List<ExpFieldItem> getBaseExpItems() {
		return baseItems;
	}
}
