package com.bokesoft.yes.excel.cmd.stamp.dependency;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.dependency.provider.IExpFieldItemProvider;
import com.bokesoft.yes.parser.LexDef;
import com.bokesoft.yes.parser.Lexer;

/**
 * 将字段列表按照其公式依赖顺序进行排序 
 * 
 * @author chenbb
 *
 */
public class FormulaEvalGroupIteratorBuilder {
	
	private Lexer lex = null;

	public FormulaEvalGroupIteratorBuilder() {
		this.lex = new Lexer();
	}
	
	public Iterator<FormulaEvalGroup> build(IExpFieldItemProvider expFieldProvider) {
		 List<ExpFieldItem> baseExpItems = expFieldProvider.getBaseExpItems();
		 buildExpItemTree(baseExpItems, expFieldProvider);
		 List<ExpFieldItem> newList = new ArrayList<>();
		 createSortedList(baseExpItems, newList);
		 return new FormulaEvalGroupIterator(newList);
	}
	
	/**
	 * 根据依赖创建新的公式执行顺序
	 * 
	 * @param baseList
	 * @param newList
	 */
	private void createSortedList(List<ExpFieldItem> baseList, List<ExpFieldItem> newList) {
		for (ExpFieldItem item : baseList) {
			if (!item.hasDependency()) {
				newList.add(item);
			} else {
				createSortedList(item.getDependencies(), newList);
				if (!newList.contains(item)) {
					newList.add(item);
				}
			}
		}
	}
	
	/**
	 * 创建公式依赖树
	 * 
	 * @param baseExpItems
	 * @param fieldItemManager
	 */
	private void buildExpItemTree(List<ExpFieldItem> baseExpItems, IExpFieldItemProvider fieldItemManager) {
		List<ExpFieldItem> removedBaseExpItems = new ArrayList<>();
		for (ExpFieldItem item : baseExpItems) {
			createChildExpItem(item, removedBaseExpItems, fieldItemManager);
		}
		
		for (ExpFieldItem removedItem: removedBaseExpItems) {
			baseExpItems.remove(removedItem);
		}
	}
	
	private void createChildExpItem(ExpFieldItem expItem, List<ExpFieldItem> removedBaseExpItems, IExpFieldItemProvider fieldItemManager) {
		if (expItem != null) {
			String defaultFormula = expItem.getFormula();
			if (!StringUtil.isBlankOrNull(defaultFormula)) {
				lex.setContent(defaultFormula);
				int lexID = lex.next();
				while (lexID != -1) {
					if (lexID == LexDef.ID || lexID == LexDef.CONST) {
						String dep = lex.getLexValue();
						if(dep != null && !dep.equals(expItem.getKey())
								&& fieldItemManager.getExpFieldItem(dep) != null) {
							ExpFieldItem child = fieldItemManager.getExpFieldItem(dep);
							expItem.addDependency(child);
							createChildExpItem(child, removedBaseExpItems, fieldItemManager);
							removedBaseExpItems.add(child);
						}
					}
					lexID = lex.next();
				}
			}
		}
	}
	
/*	public static void main(String[] args) {
		List<String> dd = new ArrayList<>();
		dd.add("ew");
		dd.add("ww");
		dd.add("dd");
		dd.add("cc");
		String tmp = null;
		Iterator<String> it = dd.iterator();
		while (it.hasNext()) {
			tmp = it.next();
			if ("dd".equalsIgnoreCase(tmp)) {
				dd.remove("dd");
			} else {
				System.out.println(tmp);
			}
		}
	}*/
}
