package com.bokesoft.yes.excel.cmd.stamp.dependency;

import java.util.Iterator;
import java.util.List;

public class FormulaEvalGroupIterator implements Iterator<FormulaEvalGroup> {
	
	private int curIndex = 0;
	
	private List<ExpFieldItem> expFieldItems = null;
	
	public FormulaEvalGroupIterator(List<ExpFieldItem> expFieldItems) {
		this.expFieldItems = expFieldItems;
	}

	@Override
	public boolean hasNext() {
		return curIndex < expFieldItems.size();
	}

	@Override
	public FormulaEvalGroup next() {
		ExpFieldItem baseExpItem = expFieldItems.get(curIndex);
		FormulaEvalGroup evalGroup = new FormulaEvalGroup(baseExpItem.getTableKey(), baseExpItem.isHead());
		evalGroup.add(baseExpItem);
		
		curIndex ++;
		ExpFieldItem tmpExpItem = null;
		while (hasNext()) {
			tmpExpItem = expFieldItems.get(curIndex);
			if (!tmpExpItem.getTableKey().equalsIgnoreCase(baseExpItem.getTableKey())) {
				break;
			}
			evalGroup.add(tmpExpItem);
			curIndex ++;
		}
		return evalGroup;
	}
	
}
