package com.bokesoft.yes.excel.cmd.normal;

import java.util.ArrayList;
import java.util.Iterator;

import com.bokesoft.yes.common.util.ConstUtil;
import com.bokesoft.yigo.common.def.ParameterSourceType;
import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaParameter;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.LoadFormData;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.document.TableFilterDetail;

public class LoadMultiPageDocument {
	/** 上下文环境*/
	private DefaultContext context = null;
	/** 重新加载数据是的过滤条件*/
	private FilterMap filterMap = null;
	/** 重新加载数据是的过滤条件*/
	private ConditionParas condParameters = null;
	public LoadMultiPageDocument(DefaultContext context, FilterMap filterMap, ConditionParas condParameters) {
		this.context = context;
		this.condParameters = condParameters;
		this.filterMap = filterMap;
	}
	
	public Document reloadDocument(MetaForm metaForm) throws Throwable {
		processParameter(context, metaForm);
		filterMap.setUseCursor(true);
		Iterator<TableFilterDetail> it = filterMap.values().iterator();
		while (it.hasNext()) {
			TableFilterDetail detail = it.next();
			if (detail != null) {
				detail.setMaxRows(0);
			}
		}

		LoadFormData loadData = new LoadFormData(metaForm.getKey(), filterMap, condParameters);
		Document document = loadData.load(context, null);
		
		return document;
	}
	
	public Document reloadDocument(MetaForm metaForm, Document richDocument) throws Throwable {
		processParameter(context, metaForm);
		filterMap.setUseCursor(true);
		Iterator<TableFilterDetail> it = filterMap.values().iterator();
		while (it.hasNext()) {
			TableFilterDetail detail = it.next();
			if (detail != null) {
				detail.setMaxRows(0);
			}
		}

		LoadFormData loadData = new LoadFormData(metaForm.getKey(), filterMap, condParameters);
		Document document = loadData.load(context, richDocument);

		return document;
	}
	
	private void processParameter(DefaultContext context, MetaForm metaForm) throws Throwable {
		MetaTableCollection metaTableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
		for (MetaTable table : metaTableCollection) {
			MetaParameterCollection paraCollection = table.getParameterCollection();
			if (paraCollection != null) {
				TableFilterDetail tableFilter = filterMap.get(table.getKey());
				if (tableFilter == null) {
					tableFilter = new TableFilterDetail(table.getKey());
					filterMap.put(table.getKey(), tableFilter);
				}
				ArrayList<Object> list = new ArrayList<Object>();
				for (MetaParameter para : paraCollection) {
					if (para.getSourceType() == ParameterSourceType.CONST)
						list.add(ConstUtil.getValue(para.getValue(), para.getDataType()));
					else if (para.getSourceType() == ParameterSourceType.FORMULA) {
						Object value = context.getMidParser().eval(ScriptType.Formula, para.getFormula());
						int dataType = para.getDataType();
						if (dataType != -1)
							value = TypeConvertor.toDataType(para.getDataType(), value);
						list.add(value);
					} else
						list.add(null);
				}
				tableFilter.setParaValues(list);
			}
		}
	}
}
