package com.bokesoft.yes.excel.cmd.normal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

import com.bokesoft.yigo.common.def.OperationState;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.ImportDictionaryHander;
import com.bokesoft.yes.mid.cmd.dict.RebuildDictTreeCmd;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.struct.dict.Item;

public class ImportDictionary implements IImport ,DictChecker{
	/** 是否删除原有明细*/
	private boolean clearOriginalData = false;
	/** 处理导入时需要的参数*/
	private ImportDictionaryHander hander = null;
	/** 记录code和OID的关系*/
	private HashMap<String, Long> codes = new HashMap<String, Long>();
	/** 记录已存在的code*/
	private HashSet<String> existCodes = new HashSet<String>();
	/** 上下文环境*/
	private DefaultContext context = null;
	/** Excel配置对象*/
	private Workbook workbook = null;
	// 保存前处理事件
	private String postServiceName = null;
	
	private boolean isRepeatCode = false;
	/**
	 * 字典导入入口类
	 * @param context 上下文环境
	 * @param workbook Excel配置对象
	 * @param clearOriginalData 是否删除旧数据
	 * @throws Throwable
	 */
	public ImportDictionary(DefaultContext context, Workbook workbook, boolean clearOriginalData,String postServiceName) throws Throwable {
		this.context = context;
		// 将字节流转换为work
		this.workbook = workbook;
		this.postServiceName = postServiceName;
		hander = new ImportDictionaryHander(context, workbook);
		this.clearOriginalData = clearOriginalData;
	}

	/**
	 * 字典导入
	 */
	public Object importData() throws Throwable {
		String itemKey = hander.getItemKey();
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaDataObject dataObject = metaFactory.getDataObject(itemKey);
		if (dataObject == null) {
			return true;
		}

		Sheet sheet = null;
		boolean firstSheet = true;
		int count = workbook.getNumberOfSheets();
		// 循环处理所有sheet
		for (int sheetIndex = 0; sheetIndex < count; sheetIndex++) {
			sheet = workbook.getSheetAt(sheetIndex);
			processImportData(itemKey, sheet, firstSheet);
			firstSheet = false;
		}
		// 参考SingleImportExcel这么写
		if (postServiceName != null && !postServiceName.isEmpty()) {
			@SuppressWarnings("unchecked")
			IServiceProcess<IServiceContext> process = (IServiceProcess<IServiceContext>) ReflectHelper.newInstance(context.getVE(), postServiceName);
			if (process != null) {
				DefaultContext newContext = new DefaultContext(context);
				newContext.setDataObject(dataObject);
				process.process(newContext);
			}
		}
		// 事务先提交 不然后面tleft、tright不能处理
		context.commit();

		RebuildDictTreeCmd cmd = new RebuildDictTreeCmd();
		cmd.setItemKey(itemKey);
		cmd.doCmd(context);
		
		context.getDictCache().removeDictCache(itemKey);
		
		return itemKey;
	}

	private void processImportData(String itemKey, Sheet sheet,
			boolean firstSheet) throws Throwable {
		String tableKey = sheet.getSheetName();
		if (firstSheet) {
			// 特殊处理第一张表单
			dealFirstSheet(itemKey, sheet);
		} else {
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			MetaDataObject dataObject = metaFactory.getDataObject(itemKey);
			MetaTable metaTable = dataObject.getTable(tableKey);
			int tableMode = metaTable.getTableMode();
			switch (tableMode) {
			case TableMode.HEAD:
				dealHeadSheet(itemKey, sheet);
				break;
			case TableMode.DETAIL:
				dealDtlSheet(itemKey, sheet);
				break;
			}
		}
	}

	private void dealHeadSheet(String itemKey, Sheet sheet) throws Throwable {
		String tableKey = sheet.getSheetName();

		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaDataObject dataObject = metaFactory.getDataObject(itemKey);
		MetaTable metaTable = dataObject.getTable(tableKey);

		ArrayList<String> fields = hander.getFieldsByTable(tableKey);

		String insertSql = hander.getInsertSQLByTable(tableKey);
		BatchPsPara insertBPP = new BatchPsPara(insertSql);

		String updateSql = hander.getUpdateSQLByTable(tableKey);
		BatchPsPara updateBPP = new BatchPsPara(updateSql);

		long SOID = 0L;
		int rowIndex = 2;
		PSArgs args = null;
		while (true) {
			String code = ExcelUtil.getCellValue(sheet, rowIndex, 0).toString().toUpperCase();
			if (code.isEmpty()) {
				break;
			}
			boolean bExist = existCodes.contains(code);
			setRepeatCode(bExist);
			SOID = codes.get(code);

			args = new PSArgs();
			if (!isRepeatCode()) {
				long OID = context.applyNewOID();
				insertBPP.putArgs(args);
				fillSystemField(metaTable, args, OID, SOID);
			}

			fillImportField(metaTable, args, sheet, rowIndex, fields);

			if (isRepeatCode()) {
				args.addArg(metaTable.getSOIDColumn().getDataType(), SOID);
				updateBPP.putArgs(args);
			}
			rowIndex++;
		}

		IDBManager dbm = context.getDBManager();
		dbm.executeUpdate(updateBPP);
		dbm.executeUpdate(insertBPP);
	}

	private void setRepeatCode(boolean bExist) {
		this.isRepeatCode = bExist;		
	}

	private void dealDtlSheet(String itemKey, Sheet sheet) throws Throwable {
		String tableKey = sheet.getSheetName();

		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaDataObject dataObject = metaFactory.getDataObject(itemKey);
		MetaTable metaTable = dataObject.getTable(tableKey);

		ArrayList<String> fields = hander.getFieldsByTable(tableKey);

		String insertSql = hander.getInsertSQLByTable(tableKey);
		BatchPsPara insertBPP = new BatchPsPara(insertSql);

		String deleteSql = hander.getDeleteSQLByTable(tableKey);
		BatchPsPara deleteBPP = new BatchPsPara(deleteSql);

		long SOID = 0L;
		int rowIndex = 2;
		PSArgs args = null;
		while (true) {
			String code = ExcelUtil.getCellValue(sheet, rowIndex, 0).toString().toUpperCase();
			if (code.isEmpty()) {
				break;
			}
			
			SOID = codes.get(code);
			// 删除原有的明细
			if (clearOriginalData) {
				args = new PSArgs();
				args.addArg(metaTable.getSOIDColumn().getDataType(), SOID);
				deleteBPP.putArgs(args);
			}

			// 新增明细
			long OID = context.applyNewOID();
			args = new PSArgs();
			fillSystemField(metaTable, args, OID, SOID);

			fillImportField(metaTable, args, sheet, rowIndex, fields);
			insertBPP.putArgs(args);

			rowIndex++;
		}

		IDBManager dbm = context.getDBManager();

		dbm.executeUpdate(deleteBPP);
		dbm.executeUpdate(insertBPP);
	}

	private void dealFirstSheet(String itemKey, Sheet sheet) throws Throwable {
		String tableKey = sheet.getSheetName();

		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaDataObject dataObject = metaFactory.getDataObject(itemKey);
		MetaTable metaTable = dataObject.getTable(tableKey);

		ArrayList<String> fields = hander.getFieldsByTable(tableKey);

		String insertSql = hander.getInsertSQLByTable(tableKey);
		BatchPsPara insertBPP = new BatchPsPara(insertSql);

		String updateSql = hander.getUpdateSQLByTable(tableKey);
		BatchPsPara updateBPP = new BatchPsPara(updateSql);

		IDictCacheProxy dictCache =  context.getDictCache();
		// 第一行为隐藏行，第二行为标题行，数据从第三行开始
		Item item = null;
		int rowIndex = 2;
		long OID = 0L;
		boolean exist = false;
		while (true) {
			PSArgs args = new PSArgs();
			String code = ExcelUtil.getCellValue(sheet, rowIndex, 1).toString().toUpperCase();
			if (code.isEmpty()) {
				break;
			}
			//导入时存在相同code则报错
			if(codes.containsKey(code)){
				throw new RuntimeException("字典"+itemKey+"导入模板的code="+code+"发现重复.");
			}
			
			// 查找是否有存在的code 有：记录下来，没有：申请OID
			item = dictCache.locate(itemKey, "Code", code, null, null, DictStateMask.All, OperationState.Default);
			if (item == null) {
				OID = context.applyNewOID();
				exist = false;
			} else {
				OID = item.getID();
				existCodes.add(code);
				exist = true;
			}
			codes.put(code, OID);
			setRepeatCode(exist);
			// 对已存在的记录做更新，不存在的做插入
			if (!isRepeatCode()) {
				insertBPP.putArgs(args);
				fillSystemField(metaTable, args, OID, OID);
			}

			fillImportField(metaTable, args, sheet, rowIndex, fields);

			if (isRepeatCode()) {
				updateBPP.putArgs(args);
				args.addArg(metaTable.getSOIDColumn().getDataType(), OID);
			}

			rowIndex++;
		}

		IDBManager dbm = context.getDBManager();
		dbm.executeUpdate(insertBPP);
		dbm.executeUpdate(updateBPP);
	}

	// 填充系统字段
	private void fillSystemField(MetaTable metaTable, PSArgs args, long OID, long SOID) {
		args.addArg(metaTable.getOIDColumn().getDataType(), OID);
		args.addArg(metaTable.getPOIDColumn().getDataType(), null);
		args.addArg(metaTable.getSOIDColumn().getDataType(), SOID);
		args.addArg(metaTable.getVERIDColumn().getDataType(), 0);
		args.addArg(metaTable.getDVERIDColumn().getDataType(), 0);
	}
	
	// 填充导入的字段
	private void fillImportField(MetaTable metaTable, PSArgs args,Sheet sheet, int rowIndex, ArrayList<String> fields) throws Throwable {
		for (int colIndex = 0; colIndex < fields.size(); colIndex++) {
			String columnKey = fields.get(colIndex);
			Object value = getValue(metaTable, sheet, rowIndex, colIndex + 1, columnKey);
			args.addArg(metaTable.get(columnKey.split(ImportDictionaryHander.SEPARATOR)[0]).getDataType(), value);
		}
	}
	
	// 从Excel中获取导入的值，根据字段类型做转换
	private Object getValue(MetaTable metaTable, Sheet sheet, int rowIndex,
			int colIndex, String fieldKey) throws Throwable {
		Object value = ExcelUtil.getCellValue(sheet, rowIndex, colIndex);
		//字典导入的Code全部转化为大写
		if (fieldKey.equals("Code")){
			value = value.toString().toUpperCase();
		}
		String[] fields = fieldKey.split(ImportDictionaryHander.SEPARATOR);
		String columnKey = fields[0];
		
		if (value != null && !value.toString().isEmpty()) {
			String sValue = TypeConvertor.toString(value);
			if (fields.length > 1) {
				value = 0;
				String itemKey = fields[1];
				if (itemKey.equals(hander.getItemKey()) && codes.containsKey(sValue.toUpperCase())) {
					value = codes.get(sValue.toUpperCase());
				} else {
					IDictCacheProxy dictCache = context.getDictCache();
					MetaDataObject dictDataObject = context.getVE().getMetaFactory().getDataObject(itemKey);
					List<MetaColumn> displayColumns = dictDataObject.getDisplayColumns();
					for (MetaColumn metaColumn : displayColumns) {
						Item item = dictCache.locate(itemKey, metaColumn.getKey(), sValue, null, null, DictStateMask.All, OperationState.Default);
						if (item != null) {
							value = item.getID();
							break;
						}
					}
				}
			}
		}

		// 根据数DataType转型
		MetaColumn column = metaTable.get(columnKey);
		int dataType = column.getDataType();
		value = TypeConvertor.toJavaType(DBTypeUtil.dataType2JavaDataType(dataType), value);

		return value;
	}

	@Override
	public boolean isRepeatCode() {
		// TODO Auto-generated method stub
		return isRepeatCode;
	}
}
