package com.bokesoft.yes.excel.cmd.normal;

import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.csv.cmd.normal.IExportPostProcess;
import com.bokesoft.yes.excel.cmd.stamp.exportor.DocumentExportor4XmlTemplate;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.util.ExcelUtils;

public class ExportExcelWithTemplate implements IExport {
	/** 上下文环境*/
	private DefaultContext context = null;
	/** 要导出的数据集*/
	private Document document = null;
	/** Excel模板配置对象*/
	private MetaExcelWorkbook metaWorkbook = null;
	/** 导出后扩展服务名*/
	private String postExportServiceName = null;
	/** 自定义导出后的文件名(不包含后缀)*/
	private String exportFileName = null;
	
	private boolean needDownload = false;
	
	public ExportExcelWithTemplate(DefaultContext context, MetaExcelWorkbook metaWorkbook, Document document, String postExportServiceName,String exportFileName,boolean needDownload) throws Throwable {
		this.context = context;
		this.metaWorkbook = metaWorkbook;
		this.document = document;
		this.postExportServiceName = postExportServiceName;
		this.exportFileName = exportFileName;
		this.needDownload = needDownload;
	}

	/**
	 * 导出数据并返回FileData
	 * @return FileData 
	 */
	public FileData exportData() throws Throwable {
		DocumentExportor4XmlTemplate exportProcess = new DocumentExportor4XmlTemplate(metaWorkbook, context);
		exportProcess.export(document, "");
		Workbook workBook = exportProcess.getWorkbook();
		
		String formKey = metaWorkbook.getFormKey();
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		
		String filePath = ExcelUtils.getExportFilePath(metaFactory, formKey);
		
		FileData fileData = new FileData();
		if (!needDownload){				
			fileData = ExcelFileUtil.writeExcel(workBook, filePath);
		}else{
			fileData = ExcelFileUtil.convertWorkbookToFileData(formKey, exportFileName, workBook);
			fileData.setPath(filePath);
		}
		IExportPostProcess process = ExcelUtils.getPostExtProcess(context, postExportServiceName);
		if( process != null ) {
			process.process(context, fileData);
		}
		if(needDownload){
			return fileData;
		}else{
			return new FileData();
		}
	}
}