//package com.bokesoft.yes.excel.cmd.normal;
//
//import java.io.File;
//import java.util.Iterator;
//
//import org.apache.poi.ss.usermodel.Workbook;
//import org.json.JSONObject;
//
//import com.bokesoft.yes.csv.cmd.normal.IExportPostProcess;
//import com.bokesoft.yes.excel.utils.ExcelUtil;
//import com.bokesoft.yes.mid.base.SvrInfo;
//import com.bokesoft.yigo.common.def.ControlType;
//import com.bokesoft.yigo.common.def.PageLoadType;
//import com.bokesoft.yigo.common.def.TableMode;
//import com.bokesoft.yigo.common.util.FileUtil;
//import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
//import com.bokesoft.yigo.meta.dataobject.MetaTable;
//import com.bokesoft.yigo.meta.enhance.MetaEnhance;
//import com.bokesoft.yigo.meta.enhance.MetaExtPostExportService;
//import com.bokesoft.yigo.meta.enhance.MetaPostExportService;
//import com.bokesoft.yigo.meta.factory.IMetaFactory;
//import com.bokesoft.yigo.meta.form.MetaForm;
//import com.bokesoft.yigo.meta.form.component.MetaComponent;
//import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
//import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
//import com.bokesoft.yigo.mid.base.DefaultContext;
//import com.bokesoft.yigo.util.MD5Util;
//
//public class ExportExcelUtil {
//	public static boolean isNeedLoadData(MetaForm metaForm, MetaDataObject metaDataObject) {
//		MetaTable metaTable = null;
//
//		Iterator<MetaTable> itTables = metaDataObject.getTableCollection().iterator();
//		while (itTables.hasNext()) {
//			metaTable = itTables.next();
//			int tableModel = metaTable.getTableMode();
//			switch (tableModel) {
//			case TableMode.DETAIL:
//				MetaComponent metaComponent = metaForm.findComponentByTable(metaTable.getKey());
//				if( metaComponent == null )
//					break;
//				switch (metaComponent.getControlType()) {
//				case ControlType.GRID:
//					MetaGrid metaGrid = (MetaGrid)metaComponent;
//					if( metaGrid.getPageLoadType() == PageLoadType.DB ) {
//						return true;
//					}
//					break;
//				case ControlType.LISTVIEW:
//					MetaListView metaListView = (MetaListView)metaComponent;
//					if( metaListView.getPageLoadType() == PageLoadType.DB ) {
//						return true;
//					}
//					break;
//				}
//			}
//		}
//		return false;
//	}
//	
//	public static void doProcessAfterExport(DefaultContext context, MetaForm metaForm, JSONObject retJSONObject, Workbook workbook, String postExportServerName) throws Throwable {
//		IMetaFactory metaFactory = context.getVE().getMetaFactory();
//		
//		String dirPath = metaFactory.getSolution().getDataPath();
//		if (dirPath == null || dirPath.isEmpty()) {
//			 dirPath = SvrInfo.getWorkDir();
//		}
//		dirPath = FileUtil.removeSlant(dirPath);
//		String filePath = dirPath + File.separator + "Excel" + File.separator + metaForm.getKey() + File.separator
//				+ metaForm.getKey() + System.currentTimeMillis() + ".xlsx";
//		
//		ExcelUtil.writeExcel(workbook, filePath);
//		
//		retJSONObject.put("filePath", filePath);
//		retJSONObject.put("formKey", metaForm.getKey());
//		retJSONObject.put("fileName", metaForm.getKey() + ".xlsx");
//		retJSONObject.put("formCaption", metaForm.getCaption());
//		File file = new File(filePath);
//		if (file.exists()) {
//			retJSONObject.put("fileSize", file.length());
//			retJSONObject.put("fileMD5", MD5Util.getMD5(file));
//		}
//
//		// 导出后自定义处理
//		MetaEnhance enhance = metaFactory.getEnhance(null);
//		if (enhance != null) {
//			MetaExtPostExportService extService = enhance.getPostExportService();
//			if (extService != null) {
//				MetaPostExportService service = extService.get(postExportServerName);
//				if (service != null) {
//					String impl = service.getImpl();
//					Class<?> svrClass = Class.forName(impl);
//					IExportPostProcess PostProcess = (IExportPostProcess)svrClass.newInstance();
//					if (PostProcess != null) {
//						PostProcess.process(new DefaultContext(context), retJSONObject);
//					}
//				}
//			}
//		}
//	}
//}
