package com.bokesoft.yes.data.service;

import java.util.ArrayList;

import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.meta.enhance.MetaDocumentService;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExtDocumentService;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class DocumentServiceManager {
	
	private boolean hasInited = false; 
	
	private static DocumentServiceManager instance = new DocumentServiceManager();
	
	private static DocumentService4IDs SERVICE_DOCUMENT4IDS = new DocumentService4IDs();

	private ArrayList<IDocumentService> listImpl = new ArrayList<>(); 
	
	private DocumentServiceManager() {
	}
	
	private void init(DefaultContext context) throws Throwable {
		MetaEnhance enhance = context.getVE().getMetaFactory().getEnhance(null);
		if (enhance != null) {
			MetaExtDocumentService extDocumentService = enhance.getExtDocumentService();
			if (extDocumentService != null) {
				for (int i = 0; i < extDocumentService.size(); ++i) {
					MetaDocumentService metaDocumentService = extDocumentService.get(i);
					if( metaDocumentService != null ) {
						IDocumentService service;
						try {
							service = (IDocumentService) ReflectHelper.newInstance(context.getVE(), metaDocumentService.getImpl());
							listImpl.add(service);
						} catch (ClassNotFoundException e) {
							e.printStackTrace();
						} catch (InstantiationException e) {
							e.printStackTrace();
						} catch (IllegalAccessException e) {
							e.printStackTrace();
						}
					}
				}
			}
		}
		
		if (!listImpl.contains(SERVICE_DOCUMENT4IDS)) {
			listImpl.add(SERVICE_DOCUMENT4IDS);
		}
		hasInited = true;
	}
	
	/**
	 * 
	 * @param context
	 * @param moduleName 	调用 来源模块名
	 * @param methodName	调用 来源方法名
	 * @param formKey		表单标志
	 * @param extCheckPara  扩展参数
	 * @return
	 * @throws Throwable
	 */
	public IDocumentService getDocumentService(DefaultContext context, String moduleName, String methodName, String formKey, Object extCheckPara) throws Throwable {
		if (!hasInited) {
			init(context);
		}
		IDocumentService docService = null;
		for (IDocumentService service : listImpl) {
			if (service.check(context, moduleName, methodName, formKey, extCheckPara)) {
				docService = service.newInstance();
				break;
			}
		}
		return docService;
	}
	
	
	public static DocumentServiceManager getInstance() {
		return instance;
	}

}
