package com.bokesoft.yes.csv.cmd.normal;

import java.io.IOException;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;

public class CSVUtil {
	/**
	 * 转换为CSV格式的值
	 * @param metaColumn 列配置对象
	 * @param content 导出的值
	 * @return 符合CSV格式的值
	 * @throws IOException
	 */
	public static String convertCSVValue(MetaColumn metaColumn, String content) throws IOException {
		if (content.contains("\"")) {
			content = content.replaceAll("\"", "\"\"");
			content = "\"" + content + "\"";
		} else if (content.contains(",")) {
			content = "\"" + content + "\"";
		}

		if (metaColumn != null) {
			int dataType = metaColumn.getDataType();
			switch (dataType) {
			case DataType.STRING:
				if (StringUtil.isNumeric(content)) {
					content = "\"'" + content + "\"";
				}
				break;
			}
		}
		
		return content;
	}
}
