/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template;

import com.bokesoft.yes.excel.template.ColumnExpandItem;
import com.bokesoft.yes.excel.template.ExcelColumnExpand;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateCellType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import java.util.ArrayList;

public class ExcelCell {
    private int cellIndex = -1;
    private int rowIndex = -1;
    private String sourceType = "Field";
    private String definition = "";
    private int mergedColumnSpan = 0;
    private int mergedRowSpan = 0;
    private boolean isColumnExpand = false;
    private ExcelColumnExpand columnExpand = null;
    private boolean columnExpandTarget = false;
    private ArrayList<ColumnExpandItem> columnExpandItemArray = null;
    private ExcelDisplay display = null;
    private String expandCaption = null;
    private Object expandValue = -1;
    private String tableKey = "";
    private String ignoreExport = "";
    public boolean need = true;

    public ExcelCell() {
    }

    public ExcelCell(MetaExcelCell metaExcelCell, int n) {
        this.rowIndex = n;
        this.cellIndex = metaExcelCell.getCellIndex();
        this.sourceType = ExcelTemplateCellType.toString((int)metaExcelCell.getSourceType());
        this.definition = metaExcelCell.getDefinition();
        this.mergedColumnSpan = metaExcelCell.getMergedColumnSpan();
        this.mergedRowSpan = metaExcelCell.getMergedRowSpan();
        this.isColumnExpand = metaExcelCell.isColumnExpand();
        this.tableKey = metaExcelCell.getTableKey();
        this.ignoreExport = metaExcelCell.getIgnoreExport();
        if (metaExcelCell.getColumnExpand() != null) {
            this.columnExpand = new ExcelColumnExpand(metaExcelCell.getColumnExpand());
        }
        if (metaExcelCell.getDisplay() != null) {
            this.display = new ExcelDisplay(metaExcelCell.getDisplay());
        }
    }

    public int getCellIndex() {
        return this.cellIndex;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getDefinition() {
        return this.definition;
    }

    public int getMergedColumnSpan() {
        return this.mergedColumnSpan;
    }

    public int getMergedRowSpan() {
        return this.mergedRowSpan;
    }

    public boolean isColumnExpand() {
        return this.isColumnExpand;
    }

    public ExcelColumnExpand getColumnExpand() {
        return this.columnExpand;
    }

    public void setCellIndex(int n) {
        this.cellIndex = n;
    }

    public void setSourceType(String string) {
        this.sourceType = string;
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public void setMergedColumnSpan(int n) {
        this.mergedColumnSpan = n;
    }

    public void setMergedRowSpan(int n) {
        this.mergedRowSpan = n;
    }

    public void setIsColumnExpand(boolean bl) {
        this.isColumnExpand = bl;
    }

    public void setColumnExpand(ExcelColumnExpand excelColumnExpand) {
        this.columnExpand = excelColumnExpand;
    }

    public void setColumnExpandTarget(boolean bl) {
        this.columnExpandTarget = bl;
    }

    public boolean getColumnExpandTarget() {
        return this.columnExpandTarget;
    }

    public void addColumnExpandItem(ColumnExpandItem columnExpandItem) {
        if (this.columnExpandItemArray == null) {
            this.columnExpandItemArray = new ArrayList();
        }
        this.columnExpandItemArray.add(columnExpandItem);
    }

    public ArrayList<ColumnExpandItem> getColumnExpandItems() {
        return this.columnExpandItemArray;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int n) {
        this.rowIndex = n;
    }

    public String getExpandCaption() {
        return this.expandCaption;
    }

    public Object getExpandValue() {
        return this.expandValue;
    }

    public void setExpandCaption(String string) {
        this.expandCaption = string;
    }

    public void setExpandValue(Object object) {
        this.expandValue = object;
    }

    public ExcelDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(ExcelDisplay excelDisplay) {
        this.display = excelDisplay;
    }

    public String getTableKey() {
        return this.tableKey;
    }

    public void setTableKey(String string) {
        this.tableKey = string;
    }

    public String getIgnoreExport() {
        return this.ignoreExport;
    }

    public ExcelCell clone() {
        ExcelCell excelCell = new ExcelCell();
        excelCell.setExpandCaption(this.expandCaption);
        excelCell.setExpandValue(this.expandValue);
        excelCell.setCellIndex(this.cellIndex);
        excelCell.setIsColumnExpand(this.isColumnExpand);
        excelCell.setColumnExpandTarget(this.columnExpandTarget);
        excelCell.setDefinition(this.definition);
        excelCell.setMergedColumnSpan(this.mergedColumnSpan);
        excelCell.setMergedRowSpan(this.mergedRowSpan);
        excelCell.setRowIndex(this.rowIndex);
        excelCell.setSourceType(this.sourceType);
        excelCell.setTableKey(this.tableKey);
        excelCell.setColumnExpand(this.columnExpand == null ? null : this.columnExpand.clone());
        excelCell.setDisplay(this.display == null ? null : this.display.clone());
        if (this.columnExpandItemArray != null) {
            for (ColumnExpandItem columnExpandItem : this.columnExpandItemArray) {
                excelCell.addColumnExpandItem(columnExpandItem.clone());
            }
        }
        return excelCell;
    }
}

