/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.exportor;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.normal.ExcelDataUtil;
import com.bokesoft.yes.excel.cmd.normal.ExcelStyleFactory;
import com.bokesoft.yes.excel.cmd.stamp.exportor.IDocumentExportor;
import com.bokesoft.yes.excel.document.ExcelDataTable;
import com.bokesoft.yes.excel.document.ExcelDetailDataRow;
import com.bokesoft.yes.excel.document.ExcelDocumentProcess;
import com.bokesoft.yes.excel.document.ExcelExpandDataRow;
import com.bokesoft.yes.excel.document.ExcelGroupDetailRow;
import com.bokesoft.yes.excel.document.GroupContext;
import com.bokesoft.yes.excel.document.IExcelDataRow;
import com.bokesoft.yes.excel.parser.ExcelContext;
import com.bokesoft.yes.excel.template.ColumnExpandItem;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yes.excel.template.ExcelRow;
import com.bokesoft.yes.excel.template.ExcelSheet;
import com.bokesoft.yes.excel.template.ExcelWorkbook;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.transformer.ExcelTransformerFactory;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumn;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.parser.IEvalContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.util.StampExcelUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class DocumentExportor4XmlTemplate
implements IDocumentExportor {
    private DefaultContext context = null;
    private ExcelContext excelContext = null;
    private Workbook workBook = null;
    private MetaExcelWorkbook metaWorkbook = null;
    private ExcelWorkbook virtualWorkbook = null;
    private ExcelTransformerFactory transformerFactory = null;
    private ExcelStyleFactory styleFactory = null;

    public DocumentExportor4XmlTemplate(MetaExcelWorkbook metaExcelWorkbook, DefaultContext defaultContext) {
        this.context = defaultContext;
        this.metaWorkbook = metaExcelWorkbook;
        this.workBook = new SXSSFWorkbook(500);
        this.styleFactory = new ExcelStyleFactory(this.workBook);
        this.transformerFactory = new ExcelTransformerFactory();
    }

    public Workbook getWorkbook() {
        return this.workBook;
    }

    @Override
    public void export(Document document, String string) throws Throwable {
        this.excelContext = new ExcelContext(this.context);
        MetaDataObject metaDataObject = document.getMetaDataObject();
        this.context.setDocument(document);
        this.context.setFormKey(this.metaWorkbook.getFormKey());
        this.context.setDataObject(metaDataObject);
        this.excelContext.setDocument(document);
        this.virtualWorkbook = new ExcelWorkbook(metaDataObject, this.metaWorkbook, this.context.getMidParser());
        this.virtualWorkbook.calcExpandColumn(this.context.getMidParser(), document, metaDataObject);
        ExcelDocumentProcess excelDocumentProcess = new ExcelDocumentProcess(metaDataObject, this.virtualWorkbook, document, this.excelContext);
        excelDocumentProcess.process();
        Iterator<ExcelSheet> iterator = this.virtualWorkbook.iterator();
        while (iterator.hasNext()) {
            Object object;
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            ExcelSheet excelSheet = iterator.next();
            Sheet sheet = ExcelUtil.getSheet((Workbook)this.workBook, (String)(StringUtil.isBlankOrNull((String)string) ? excelSheet.getName() : string));
            int n = 0;
            Iterator<ExcelRow> iterator2 = excelSheet.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                switch (((ExcelRow)object).getType()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        this.exportFixRow(document, metaDataObject, sheet, (ExcelRow)object, n, hashMap);
                        break;
                    }
                    case 3: {
                        n = this.exportDetailRow(excelDocumentProcess, document, metaDataObject, sheet, (ExcelRow)object, n, hashMap);
                        break;
                    }
                    case 4: {
                        --n;
                    }
                }
            }
            object = excelSheet.columnIterator();
            while (object.hasNext()) {
                MetaExcelColumn metaExcelColumn = (MetaExcelColumn)object.next();
                int n2 = metaExcelColumn.getColumnIndex();
                n = (metaExcelColumn.getWidth() << 8) / 7;
                hashMap.put(n2 - 1, n);
            }
            ExcelUtil.setSheetColumnWidth((Sheet)sheet, hashMap);
        }
    }

    private int exportDetailRow(ExcelDocumentProcess object, Document document, MetaDataObject metaDataObject, Sheet sheet, ExcelRow excelRow, int n, HashMap<Integer, Integer> hashMap) throws Throwable {
        this.excelContext.setExcelRow(excelRow);
        Object object2 = excelRow.getTableKey();
        object = ((ExcelDocumentProcess)object).getExcelDataTable((String)object2);
        if (object == null) {
            return n;
        }
        int n2 = excelRow.getRowIndex() - 1;
        document = document.get((String)object2);
        metaDataObject = metaDataObject.getMetaTable((String)object2);
        this.excelContext.setDataTable((DataTable)document);
        this.excelContext.setMetaTable((MetaTable)metaDataObject);
        object2 = ((ExcelDataTable)object).iterator();
        int n3 = 0;
        HashMap<Integer, GroupContext> hashMap2 = new HashMap<Integer, GroupContext>();
        int n4 = 0;
        while (object2.hasNext()) {
            int n5 = n2 + n;
            object = ExcelUtil.getRow((Sheet)sheet, (int)n5);
            object.setHeightInPoints((float)((short)excelRow.getHeight()));
            IExcelDataRow iExcelDataRow = (IExcelDataRow)object2.next();
            String string = iExcelDataRow.getType();
            if ("Expand".equalsIgnoreCase(string)) {
                this.fillExpandData((Row)object, (ExcelExpandDataRow)iExcelDataRow, (DataTable)document, excelRow, (MetaTable)metaDataObject, hashMap);
            } else if ("Detail".equalsIgnoreCase(string)) {
                this.fillDetailData(sheet, n5, (ExcelDetailDataRow)iExcelDataRow, (DataTable)document, excelRow, (MetaTable)metaDataObject, hashMap, hashMap2, n4);
            } else if ("GroupDetail".equalsIgnoreCase(string)) {
                this.fillGroupData(sheet, n5, (ExcelGroupDetailRow)iExcelDataRow, (DataTable)document, excelRow, (MetaTable)metaDataObject, hashMap, hashMap2, n4);
            }
            ++n;
            ++n3;
            ++n4;
        }
        hashMap2.clear();
        if (n3 > 0) {
            --n;
        }
        return n;
    }

    private void fillGroupData(Sheet sheet, int n, ExcelGroupDetailRow object, DataTable dataTable, ExcelRow object2, MetaTable metaTable, HashMap<Integer, Integer> hashMap, HashMap<Integer, GroupContext> object3, int n2) throws Throwable {
        GroupContext groupContext = new GroupContext();
        groupContext.addDefinition(((ExcelGroupDetailRow)object).getGroupLevel(), ((ExcelGroupDetailRow)object).getDefinition());
        ((HashMap)object3).put(n2, (GroupContext)groupContext);
        object3 = ((HashMap)object3).get(n2 - 1);
        this.excelContext.setDetailRows(((ExcelGroupDetailRow)object).getDetailRows());
        object = ((ExcelGroupDetailRow)object).getExcelRow().iterator();
        while (object.hasNext()) {
            object2 = (ExcelCell)object.next();
            if (((ExcelCell)object2).getCellIndex() == -1) continue;
            this.fillCellData(dataTable, metaTable, sheet, n, (ExcelCell)object2, hashMap, groupContext, (GroupContext)object3);
        }
    }

    private void fillDetailData(Sheet sheet, int n, ExcelDetailDataRow object, DataTable dataTable, ExcelRow object2, MetaTable metaTable, HashMap<Integer, Integer> hashMap, HashMap<Integer, GroupContext> object3, int n2) throws Throwable {
        this.excelContext.setExcelDetailDataRow((ExcelDetailDataRow)object);
        GroupContext groupContext = new GroupContext();
        groupContext.setDefinitionMap(((ExcelDetailDataRow)object).getDefinitionMap());
        ((HashMap)object3).put(n2, (GroupContext)groupContext);
        object3 = ((HashMap)object3).get(n2 - 1);
        dataTable.setPos(((ExcelDetailDataRow)object).getRowIndex());
        object = ((ExcelRow)object2).iterator();
        while (object.hasNext()) {
            object2 = (ExcelCell)object.next();
            this.fillCellData(dataTable, metaTable, sheet, n, (ExcelCell)object2, hashMap, groupContext, (GroupContext)object3);
        }
    }

    private void fillExpandData(Row row, ExcelExpandDataRow excelExpandDataRow, DataTable dataTable, ExcelRow object, MetaTable metaTable, HashMap<Integer, Integer> hashMap) throws Throwable {
        object = ((ExcelRow)object).iterator();
        while (object.hasNext()) {
            ExcelCell excelCell = (ExcelCell)object.next();
            Object object2 = excelCell.getDefinition();
            Object object3 = excelCell.getSourceType();
            boolean bl = false;
            int n = excelCell.getCellIndex() - 1;
            Cell cell = ExcelUtil.getCell((Row)row, (int)n);
            Object object4 = null;
            if (((String)object3).equalsIgnoreCase("field")) {
                object3 = excelCell.getColumnExpandTarget() ? this.findRowInExpandRow(dataTable, excelExpandDataRow, excelCell) : excelExpandDataRow.getRow(0);
                if (object3 != null) {
                    object2 = (MetaColumn)metaTable.get((String)object2);
                    object4 = dataTable.getObject(object3.getRowIndex(), object2.getKey());
                    object2 = this.transformerFactory.getTransformer((VE)this.context.getVE(), excelCell);
                    if (object2 != null) {
                        object4 = object2.transform(excelCell, object4);
                    }
                }
            } else if (((String)object3).equalsIgnoreCase("const")) {
                object4 = object2;
            } else if (((String)object3).equalsIgnoreCase("formula")) {
                this.excelContext.setExcelExpandDataRow(excelExpandDataRow);
                object4 = this.excelContext.getMidParser().eval(0, (String)object2, (IEvalContext)this.excelContext, null);
            }
            if (object4 != null) {
                if (object4 instanceof BigDecimal) {
                    if (((BigDecimal)object4).compareTo(BigDecimal.ZERO) != 0) {
                        ExcelUtil.setCellValue((Cell)cell, (Object)object4);
                    }
                } else {
                    ExcelUtil.setCellValue((Cell)cell, (Object)object4);
                }
            }
            if ((object2 = excelCell.getDisplay()) != null) {
                bl = ((ExcelDisplay)object2).isWrapText();
            }
            if (bl) {
                this.styleFactory.getCellStyle(excelCell).setWrapText(bl);
            }
            cell.setCellStyle(this.styleFactory.getCellStyle(excelCell));
            ExcelUtil.calcMaxColumnWidth((Cell)cell, hashMap, (int)n);
        }
    }

    private IExcelDataRow findRowInExpandRow(DataTable dataTable, ExcelExpandDataRow excelExpandDataRow, ExcelCell object) {
        Object object2 = null;
        ArrayList<ColumnExpandItem> arrayList = ((ExcelCell)object).getColumnExpandItems();
        int n = excelExpandDataRow.size();
        for (int i = 0; i < n; ++i) {
            object = (ExcelDetailDataRow)excelExpandDataRow.getRow(i);
            boolean bl = true;
            for (ColumnExpandItem columnExpandItem : arrayList) {
                Object object3 = dataTable.getObject(((ExcelDetailDataRow)object).getRowIndex(), columnExpandItem.getKey());
                if (ExcelDataUtil.equals(columnExpandItem.getValue(), object3)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            object2 = object;
            break;
        }
        return object2;
    }

    private void exportFixRow(Document document, MetaDataObject metaDataObject, Sheet sheet, ExcelRow object, int n, HashMap<Integer, Integer> hashMap) throws Throwable {
        n = ((ExcelRow)object).getRowIndex() - 1 + n;
        ExcelUtil.getRow((Sheet)sheet, (int)n).setHeightInPoints((float)((short)((ExcelRow)object).getHeight()));
        this.excelContext.setExcelRow((ExcelRow)object);
        Iterator<ExcelCell> iterator = ((ExcelRow)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            String string = ((ExcelCell)object).getTableKey();
            MetaTable metaTable = metaDataObject.getMetaTable(string);
            string = document.get(string);
            this.fillCellData((DataTable)string, metaTable, sheet, n, (ExcelCell)object, hashMap, null, null);
        }
    }

    private void fillCellData(DataTable object, MetaTable metaTable, Sheet sheet, int n, ExcelCell excelCell, HashMap<Integer, Integer> hashMap, GroupContext groupContext, GroupContext groupContext2) throws Throwable {
        int n2 = excelCell.getCellIndex() - 1;
        int n3 = excelCell.getMergedColumnSpan() - 1;
        int n4 = excelCell.getMergedRowSpan() - 1;
        boolean bl = false;
        String string = excelCell.getDefinition();
        Row row = ExcelUtil.getRow((Sheet)sheet, (int)n);
        Cell cell = ExcelUtil.getCell((Row)row, (int)n2);
        String string2 = excelCell.getSourceType();
        Object object2 = null;
        if (string2.equalsIgnoreCase("field")) {
            object2 = excelCell.getColumnExpandTarget() ? (excelCell.getExpandCaption() == null ? excelCell.getExpandValue() : excelCell.getExpandCaption()) : object.getObject(string);
        } else if (string2.equalsIgnoreCase("const")) {
            object2 = string;
        } else if (string2.equalsIgnoreCase("formula")) {
            object2 = this.excelContext.getMidParser().eval(0, string, (IEvalContext)this.excelContext, null);
            object = string.split("\\(");
            if ("SumExpandPortrait".equalsIgnoreCase(string = object[0])) {
                int n5 = this.excelContext.getExpandCount();
                if (n5 < ((Object)(object = ((String)object[1]).substring(((String)object[1]).indexOf("{") + 1, ((String)object[1]).lastIndexOf("}")).split(","))).length - 1) {
                    this.excelContext.setExpandCount(++n5);
                } else {
                    this.excelContext.setExpandCount(0);
                }
            }
        }
        object = excelCell.getDisplay();
        if (object != null) {
            bl = ((ExcelDisplay)object).isWrapText();
        }
        string = this.styleFactory.getCellStyle(excelCell);
        if (bl) {
            string.setWrapText(bl);
        }
        if (n3 > 0 || n4 > 0) {
            for (int i = 0; i <= n3; ++i) {
                for (int j = 0; j <= n4; ++j) {
                    ExcelUtil.getCell((Sheet)sheet, (int)(n + j), (int)(n2 + i)).setCellStyle((CellStyle)string);
                }
            }
            int n6 = n;
            int n7 = n2;
            sheet.addMergedRegionUnsafe(new CellRangeAddress(n6, n6 + n4, n7, n7 + n3));
        } else {
            cell.setCellStyle((CellStyle)string);
        }
        short s = StampExcelUtil.getExcelCellStyle(excelCell, this.workBook);
        if (s != -1) {
            string.setDataFormat(s);
        } else {
            object = this.transformerFactory.getTransformer((VE)this.context.getVE(), excelCell);
            if (object != null) {
                object2 = object.transform(excelCell, object2);
            }
        }
        cell = ExcelUtil.getCell((Row)row, (int)n2);
        if (StampExcelUtil.isNumericCell(excelCell)) {
            cell.setCellType(CellType.NUMERIC);
        }
        if (object2 != null) {
            if (object2 instanceof BigDecimal) {
                if (((BigDecimal)object2).compareTo(BigDecimal.ZERO) != 0) {
                    ExcelUtil.setCellValue((Cell)cell, (Object)object2);
                }
            } else {
                ExcelUtil.setCellValue((Cell)cell, (Object)object2);
            }
        }
        if (groupContext != null) {
            groupContext.putDisplayValue(excelCell.getCellIndex(), TypeConvertor.toString((Object)object2));
        }
        if (!(n3 > 0)) {
            ExcelUtil.calcMaxColumnWidth((Cell)cell, hashMap, (int)n2);
        }
    }
}

