/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.exportor;

import com.bokesoft.yes.excel.cmd.stamp.exportor.IDocumentExportor;
import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputSheetProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.strategy.IOutputStrategy;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.transformer.ExcelTransformerFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
import java.util.LinkedHashMap;

public class DocumentExportor4Stamp
implements IDocumentExportor {
    private DefaultContext context = null;
    private IOutputStrategy outputStrategy = null;
    private ExcelTemplate excelTemplate = null;
    private ExcelTransformerFactory transformerFactory = null;
    private LinkedHashMap<String, OutputSheetProcess> mapSheetProcess = null;

    public DocumentExportor4Stamp(IOutputStrategy iOutputStrategy, ExcelTemplate excelTemplate, ExcelTransformerFactory excelTransformerFactory, DefaultContext defaultContext) {
        this.context = defaultContext;
        this.excelTemplate = excelTemplate;
        this.outputStrategy = iOutputStrategy;
        this.transformerFactory = excelTransformerFactory;
        this.init();
    }

    private void init() {
        this.mapSheetProcess = new LinkedHashMap();
        for (ExcelTemplateSheet excelTemplateSheet : this.excelTemplate.getTemplateSheets()) {
            OutputSheetProcess outputSheetProcess = new OutputSheetProcess(excelTemplateSheet);
            this.mapSheetProcess.put(excelTemplateSheet.getSheetName(), outputSheetProcess);
        }
    }

    @Override
    public void export(Document document, String object) throws Throwable {
        this.context.setDocument(document);
        object = this.getDetailLinkedValue(document);
        this.outputStrategy.preOutputExcel(this.excelTemplate);
        for (OutputSheetProcess outputSheetProcess : this.mapSheetProcess.values()) {
            this.outputStrategy.preOutputSheet(outputSheetProcess);
            outputSheetProcess.doProcess(document, object, this.transformerFactory, this.context, this.outputStrategy, this.excelTemplate.isNeedResetCellIndex());
            this.outputStrategy.postOutputSheet(outputSheetProcess);
        }
        this.outputStrategy.postOutputExcel(this.excelTemplate);
    }

    private Object getDetailLinkedValue(Document document) {
        Object object = null;
        ExcelTemplateField excelTemplateField = this.excelTemplate.getDetailLinkedField();
        if (excelTemplateField != null) {
            document = document.get(excelTemplateField.getTableKey());
            document.first();
            if (document != null) {
                object = document.getObject(excelTemplateField.getDefine());
            }
        }
        return object;
    }
}

