/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.expand.work;

import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.excel.template.util.ExcelTemplateUtils;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.struct.expand.IExpandWork;
import com.bokesoft.yigo.struct.expand.processor.DimensionItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelTableHeadExpandWork
implements IExpandWork<ExcelTemplateField, ExcelTemplateField> {
    private Workbook workbook = null;
    private StampExcelStyleFactory styleFactory = null;
    private ExcelTemplateTable templateTable = null;

    public ExcelTableHeadExpandWork(Workbook workbook, ExcelTemplateTable excelTemplateTable, StampExcelStyleFactory stampExcelStyleFactory) {
        this.workbook = workbook;
        this.templateTable = excelTemplateTable;
        this.styleFactory = stampExcelStyleFactory;
    }

    public void doWork(List<String> list, List<DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField>> object, List<DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField>> list2) {
        ExcelTemplateField excelTemplateField;
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            DimensionItem dimensionItem = (DimensionItem)object.next();
            n = Math.max(((ExcelTemplateField)dimensionItem.getSourceField()).getDimensionCount(), n);
            this.shiftExpandCells((DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField>)dimensionItem, this.templateTable, this.workbook);
            ArrayList<ExcelTemplateField> arrayList = new ArrayList<ExcelTemplateField>();
            int n2 = ((ExcelTemplateField)dimensionItem.getSourceField()).getColIndex();
            this.calcChildrenExpandFields(dimensionItem.getChildren(), arrayList, n2);
            for (ExcelTemplateField excelTemplateField2 : arrayList) {
                this.fillFieldCaption(excelTemplateField2, this.workbook, this.styleFactory);
            }
            ExcelTemplateField excelTemplateField2 = (ExcelTemplateField)dimensionItem.getSourceField();
            excelTemplateField = this.templateTable.getDetailHeadField(excelTemplateField2.getColIndex());
            if (excelTemplateField == null) continue;
            ExcelTemplateField excelTemplateField3 = excelTemplateField;
            excelTemplateField3.setColSpan(excelTemplateField3.getColSpan() + dimensionItem.getLeafCount() - 1);
        }
        int n3 = this.templateTable.hasDetailHead() ? n + 1 : n;
        for (String string : list) {
            excelTemplateField = this.templateTable.getField(string);
            ExcelTemplateField excelTemplateField4 = this.templateTable.getDetailHeadField(excelTemplateField.getColIndex());
            if (excelTemplateField4 == null || excelTemplateField4.getColSpan() > 1) continue;
            excelTemplateField4.setRowSpan(n3);
        }
        ExcelTableHeadExpandWork excelTableHeadExpandWork = this;
        excelTableHeadExpandWork.removeDetailHeadInTemplateTable(excelTableHeadExpandWork.templateTable);
        for (ExcelTemplateField excelTemplateField5 : this.templateTable.getFields()) {
            ExcelTableHeadExpandWork excelTableHeadExpandWork2 = this;
            excelTableHeadExpandWork2.updateSytemSheet(excelTableHeadExpandWork2.workbook, excelTemplateField5);
        }
        ExcelTableHeadExpandWork excelTableHeadExpandWork3 = this;
        excelTableHeadExpandWork3.removeBaseExpandField(excelTableHeadExpandWork3.templateTable);
    }

    private void removeBaseExpandField(ExcelTemplateTable excelTemplateTable) {
        ArrayList<ExcelTemplateField> arrayList = new ArrayList<ExcelTemplateField>();
        for (ExcelTemplateField excelTemplateField : excelTemplateTable.getFields()) {
            if (!excelTemplateField.isDimensionField() && !excelTemplateField.isExpandField()) continue;
            arrayList.add(excelTemplateField);
        }
        for (ExcelTemplateField excelTemplateField : arrayList) {
            excelTemplateTable.remove(excelTemplateField);
        }
    }

    private void removeDetailHeadInTemplateTable(ExcelTemplateTable excelTemplateTable) {
        ArrayList<ExcelTemplateField> arrayList = new ArrayList<ExcelTemplateField>();
        int n = excelTemplateTable.getStartDtlRowIndex();
        for (ExcelTemplateField excelTemplateField : excelTemplateTable.getFields()) {
            if (excelTemplateField.getRowIndex() >= n || excelTemplateField.getSourceType() != 2) continue;
            arrayList.add(excelTemplateField);
        }
        for (ExcelTemplateField excelTemplateField : arrayList) {
            excelTemplateTable.remove(excelTemplateField);
        }
    }

    private void shiftExpandCells(DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField> excelTemplateField, ExcelTemplateTable excelTemplateTable, Workbook workbook) {
        int n = excelTemplateField.getLeafCount() - 1;
        excelTemplateField = (ExcelTemplateField)excelTemplateField.getSourceField();
        int n2 = excelTemplateField.getColIndex();
        int n3 = excelTemplateField.getRowIndex();
        excelTemplateField = workbook.getSheet(excelTemplateField.getSheetName());
        for (int i = excelTemplateTable.getFirstRowIndex(); i <= n3; ++i) {
            short s = excelTemplateField.getRow(i).getLastCellNum();
            excelTemplateField.getRow(i).shiftCellsRight(n2 + 1, (int)s, n);
        }
    }

    private void fillFieldCaption(ExcelTemplateField excelTemplateField, Workbook workbook, StampExcelStyleFactory stampExcelStyleFactory) {
        ExcelUtil.setCellValue((Sheet)ExcelUtil.getSheet((Workbook)workbook, (String)excelTemplateField.getSheetName()), (int)excelTemplateField.getRowIndex(), (int)excelTemplateField.getColIndex(), (Object)excelTemplateField.getDefine(), (ExcelTemplateField)excelTemplateField, (StampExcelStyleFactory)stampExcelStyleFactory);
    }

    private void calcChildrenExpandFields(List<DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField>> object, List<ExcelTemplateField> list, int n) {
        if (object == null || object.size() == 0) {
            return;
        }
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            DimensionItem dimensionItem = (DimensionItem)object.next();
            ExcelTemplateField excelTemplateField = (ExcelTemplateField)dimensionItem.getDimensionField();
            ExcelTemplateField excelTemplateField2 = ExcelTemplateField.create((String)dimensionItem.getData().getCaption(), (int)excelTemplateField.getRowIndex(), (int)(n + n2), (String)excelTemplateField.getSheetName());
            excelTemplateField2.setExpandBy(excelTemplateField);
            list.add(excelTemplateField2);
            int n3 = dimensionItem.getLeafCount();
            excelTemplateField2.setColSpan(n3);
            this.calcChildrenExpandFields(dimensionItem.getChildren(), list, n + n2);
            n2 += n3;
        }
    }

    private void updateSytemSheet(Workbook workbook, ExcelTemplateField excelTemplateField) {
        workbook = ExcelUtil.getSheet((Workbook)workbook, (String)"YIGO_TEMPLATE");
        String string = ExcelTemplateUtils.getBindCellStr((String)excelTemplateField.getSheetName(), (int)(excelTemplateField.getRowIndex() + 1), (int)(excelTemplateField.getColIndex() + 1));
        int n = this.findRowIndexByDefine((Sheet)workbook, excelTemplateField.getDefine());
        if (n >= 0) {
            ExcelUtil.setCellFormula((Sheet)workbook, (int)n, (int)5, (String)string);
            excelTemplateField = this.templateTable.getDetailHeadField(excelTemplateField.getColIndex());
            if (excelTemplateField != null) {
                string = ExcelTemplateUtils.getBindCellStr((String)excelTemplateField.getSheetName(), (int)(excelTemplateField.getRowIndex() + 1), (int)(excelTemplateField.getColIndex() + 1));
                ExcelUtil.setCellFormula((Sheet)workbook, (int)n, (int)14, (String)string);
            }
        }
    }

    private int findRowIndexByDefine(Sheet sheet, String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            Object object = ExcelUtil.getCellValue((Sheet)sheet, (int)i, (int)6);
            if (!string.equals(object)) continue;
            return i;
        }
        return -1;
    }
}

