/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.normal.ExcelStyleFactory;
import com.bokesoft.yes.excel.cmd.normal.ExportComponentInfo;
import com.bokesoft.yes.excel.cmd.normal.ExportExcelParas;
import com.bokesoft.yes.excel.cmd.normal.IExport;
import com.bokesoft.yes.excel.cmd.normal.LoadMultiPageDocument;
import com.bokesoft.yes.excel.datatransfer.DataTransferUtil;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yes.excel.template.ExcelRow;
import com.bokesoft.yes.excel.template.ExcelSheet;
import com.bokesoft.yes.excel.template.ExcelWorkbook;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.mid.authority.util.AuthorityCheckUtil;
import com.bokesoft.yes.mid.connection.dbmanager.NormalQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.PsPara;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.util.ExcelUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.json.JSONObject;

public class ExportDictWithTemplate
implements IExport {
    private DefaultContext context = null;
    private String itemKey = null;
    private String postExportServiceName;
    private Workbook workBook = null;
    private MetaExcelWorkbook metaWorkbook = null;
    private ExcelWorkbook virtualWorkbook = null;
    private String exportFileName = null;
    private boolean needDownload = false;
    private ExcelStyleFactory styleFactory = null;
    private ExportExcelParas paras = null;
    private MetaForm metaForm = null;
    private ArrayList<Map> dictList = new ArrayList();

    public ExportDictWithTemplate(DefaultContext defaultContext, MetaExcelWorkbook metaExcelWorkbook, String string, String string2, String string3, boolean bl) throws Throwable {
        this.context = defaultContext;
        this.metaWorkbook = metaExcelWorkbook;
        this.postExportServiceName = string2;
        this.exportFileName = string3;
        this.needDownload = bl;
        metaExcelWorkbook = defaultContext.getVE().getMetaFactory();
        this.metaForm = metaExcelWorkbook.getMetaForm(string);
        this.itemKey = this.metaForm.getDataSource().getDataObject().getKey();
        this.paras = new ExportExcelParas(defaultContext, this.metaForm);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileData exportData() throws Throwable {
        Object object;
        PsPara psPara;
        block10: {
            ResultSet resultSet = null;
            psPara = null;
            new FileData();
            try {
                object = this.metaWorkbook.getFormKey();
                MetaForm metaForm = this.context.getVE().getMetaFactory().getMetaForm((String)object);
                object = metaForm.getDataSource().getDataObject();
                Object object2 = this.context.getDBManager();
                this.virtualWorkbook = new ExcelWorkbook((MetaDataObject)object, this.metaWorkbook, this.context.getMidParser());
                this.workBook = new SXSSFWorkbook(500);
                this.styleFactory = new ExcelStyleFactory(this.workBook);
                ExportDictWithTemplate exportDictWithTemplate = this;
                Object object3 = exportDictWithTemplate.getDictSql(exportDictWithTemplate.context, this.itemKey);
                psPara = new PsPara(object2.preparedQueryStatement(object3.getSQL()), object3.getSQL());
                resultSet = object2.executeQuery(psPara, (QueryArguments)new NormalQueryArguments(object3.getPrepareValues().toArray()));
                while (resultSet.next()) {
                    object3 = TypeConvertor.toLong((Object)resultSet.getObject(1));
                    this.prepareSingleData(new DefaultContext(this.context), (Long)object3, (MetaDataObject)object);
                }
                object3 = this.context.getVE().getMetaFactory();
                Iterator<ExcelSheet> iterator = this.virtualWorkbook.iterator();
                while (iterator.hasNext()) {
                    JSONObject jSONObject = new JSONObject();
                    object = iterator.next();
                    object2 = ExcelUtil.getSheet((Workbook)this.workBook, (String)((ExcelSheet)object).getName());
                    Iterator<ExcelRow> iterator2 = ((ExcelSheet)object).iterator();
                    while (iterator2.hasNext()) {
                        object = iterator2.next();
                        int n = ((ExcelRow)object).getRowIndex() - 1;
                        ExcelUtil.getRow((Sheet)object2, (int)n);
                        Iterator<ExcelCell> iterator3 = ((ExcelRow)object).iterator();
                        while (iterator3.hasNext()) {
                            ExcelCell excelCell = iterator3.next();
                            String string = excelCell.getSourceType();
                            int n2 = excelCell.getCellIndex() - 1;
                            object = ExcelUtil.getCell((Row)ExcelUtil.getRow((Sheet)object2, (int)n), (int)n2);
                            this.fillData((Sheet)object2, (Cell)object, excelCell, string, jSONObject);
                        }
                    }
                }
                String string = ExcelUtils.getExportFilePath((IMetaFactory)object3, metaForm.getKey());
                object = !this.needDownload ? ExcelFileUtil.writeExcel(this.workBook, string) : ExcelFileUtil.convertWorkbookToFileData(metaForm.getKey(), this.exportFileName, this.workBook);
                object2 = ExcelUtils.getPostExtProcess(this.context, this.postExportServiceName);
                if (object2 != null) {
                    object2.process(this.context, (FileData)object);
                }
                if (resultSet == null) break block10;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (psPara != null) {
                    psPara.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        psPara.close();
        if (!this.needDownload) {
            return new FileData();
        }
        return object;
    }

    private void fillData(Sheet sheet, Cell cell, ExcelCell excelCell, String string, JSONObject jSONObject) {
        int n = cell.getRowIndex();
        int n2 = cell.getColumnIndex();
        boolean bl = false;
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (n2 != TypeConvertor.toInteger((Object)string2)) continue;
            n = jSONObject.getInt(string2);
        }
        if (string.equalsIgnoreCase("const")) {
            ExcelUtil.setCellValue((Sheet)sheet, (int)n, (int)n2, (Object)excelCell.getDefinition());
            ++n;
        } else if (string.equalsIgnoreCase("field")) {
            for (int i = 0; i < this.dictList.size(); ++i) {
                string = this.dictList.get(i).get(excelCell.getDefinition());
                ExcelUtil.setCellValue((Sheet)sheet, (int)n, (int)n2, (Object)string);
                ++n;
            }
        }
        ExcelDisplay excelDisplay = excelCell.getDisplay();
        if (excelDisplay != null) {
            bl = excelDisplay.isWrapText();
        }
        if (bl) {
            this.styleFactory.getCellStyle(excelCell).setWrapText(bl);
        }
        jSONObject.put(TypeConvertor.toString((Object)n2), (Object)TypeConvertor.toString((Object)n));
    }

    private PrepareSQL getDictSql(DefaultContext object, String string) throws Throwable {
        MetaTable metaTable = object.getVE().getMetaFactory().getDataObject(string).getMainTable();
        String string2 = metaTable.getOIDColumn().getBindingDBColumnName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ");
        stringBuffer.append(string2);
        stringBuffer.append(" from ");
        stringBuffer.append(metaTable.getBindingDBTableName());
        ArrayList arrayList = new ArrayList();
        object = AuthorityCheckUtil.dictAuthoritySql((DefaultContext)object, (String)string, (String)string2, (int)0);
        if (object != null && !StringUtil.isBlankOrNull((String)object.getSQL())) {
            stringBuffer.append(" where " + object.getSQL());
            arrayList.addAll(object.getPrepareValues());
        }
        object = this.getOrderBySQL(metaTable);
        stringBuffer.append(" order by ");
        stringBuffer.append((String)object);
        object = new PrepareSQL();
        object.setSQL(stringBuffer.toString());
        object.addAllValue(arrayList);
        return object;
    }

    private String getOrderBySQL(MetaTable metaTable) {
        StringBuffer stringBuffer = new StringBuffer();
        for (MetaColumn metaColumn : metaTable) {
            switch (metaColumn.getSort()) {
                case 1: {
                    stringBuffer.append(",");
                    stringBuffer.append(metaColumn.getBindingDBColumnName());
                    break;
                }
                case 2: {
                    stringBuffer.append(",");
                    stringBuffer.append(metaColumn.getBindingDBColumnName());
                    stringBuffer.append(" Desc");
                }
            }
        }
        if (stringBuffer.length() == 0) {
            Iterator iterator = (MetaColumn)metaTable.get("TLeft");
            stringBuffer.append(",");
            stringBuffer.append(iterator.getBindingDBColumnName());
        }
        return stringBuffer.toString().substring(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareSingleData(DefaultContext defaultContext, long l, MetaDataObject object) throws Throwable {
        FilterMap filterMap = new FilterMap();
        filterMap.setOID(l);
        Document document = new LoadMultiPageDocument(defaultContext, filterMap, null).reloadDocument(this.metaForm);
        try {
            for (MetaTable metaTable : object.getTableCollection()) {
                this.prepareData(defaultContext, metaTable, document);
            }
            if (document == null) return;
        }
        catch (Throwable throwable) {
            if (document == null) throw throwable;
            document.close();
            throw throwable;
        }
        document.close();
    }

    private void prepareData(DefaultContext defaultContext, MetaTable object, Document document) throws Throwable {
        object = object.getKey();
        ArrayList<String> arrayList = this.paras.getColumnListByTableKey((String)object);
        HashMap<String, ExportComponentInfo> hashMap = this.paras.getComponentInfoByTableKey((String)object);
        Object object2 = null;
        document = document.get((String)object);
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        document.beforeFirst();
        while (document.next(true)) {
            for (String string : arrayList) {
                object = hashMap.get(string);
                if (object != null) {
                    object2 = DataTransferUtil.convertFieldValue((VE)defaultContext.getVE(), this.metaForm, ((ExportComponentInfo)object).getControlType(), ((ExportComponentInfo)object).getProperties(), (DataTable)document, string);
                }
                hashMap2.put(string, object2);
            }
        }
        this.dictList.add(hashMap2);
    }
}

